/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block.otherworld;

import com.klikli_dev.occultism.api.common.data.OtherworldBlockTier;
import com.klikli_dev.occultism.api.common.item.IOtherworldTool;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.registry.OccultismEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public interface IOtherworldBlock {
    public static final Property<Boolean> UNCOVERED = BooleanProperty.create((String)"uncovered");

    public Block getUncoveredBlock();

    public Block getCoveredBlock();

    public OtherworldBlockTier getTier();

    default public OtherworldBlockTier getPlayerHarvestTier(Player player, ItemStack tool) {
        OtherworldBlockTier effectTier;
        OtherworldBlockTier toolTier = OtherworldBlockTier.NONE;
        OtherworldBlockTier otherworldBlockTier = effectTier = player.hasEffect(OccultismEffects.THIRD_EYE) ? OtherworldBlockTier.ONE : OtherworldBlockTier.NONE;
        if (tool.getItem() instanceof IOtherworldTool) {
            toolTier = ((IOtherworldTool)tool.getItem()).getHarvestTier(tool);
        }
        if (tool.has(OccultismDataComponents.OTHERWORLD_TOOL_TIER)) {
            toolTier = OtherworldBlockTier.get((Integer)tool.get(OccultismDataComponents.OTHERWORLD_TOOL_TIER));
        }
        return OtherworldBlockTier.max(toolTier, effectTier);
    }

    default public BlockState getHarvestState(Player player, BlockState state, ItemStack tool) {
        return this.getPlayerHarvestTier(player, tool).getLevel() >= this.getTier().getLevel() ? (BlockState)state.setValue(UNCOVERED, (Comparable)Boolean.valueOf(true)) : state;
    }

    default public ItemStack getItem(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)((Boolean)state.getValue(UNCOVERED) != false ? this.getUncoveredBlock() : this.getCoveredBlock()), 1);
    }
}

