/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.gui.spirit;

import com.klikli_dev.occultism.client.gui.controls.LabelWidget;
import com.klikli_dev.occultism.common.container.spirit.SpiritContainer;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.util.TextUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class SpiritGui<T extends SpiritContainer>
extends AbstractContainerScreen<T> {
    protected static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/gui/inventory_spirit.png");
    protected static final String TRANSLATION_KEY_BASE = "gui.occultism.spirit";
    protected SpiritEntity spirit;
    protected T container;

    public SpiritGui(T container, Inventory playerInventory, Component titleIn) {
        super(container, playerInventory, titleIn);
        this.container = container;
        this.spirit = ((SpiritContainer)((Object)this.container)).spirit;
        this.imageWidth = 175;
        this.imageHeight = 165;
    }

    public static void drawEntityToGui(GuiGraphics guiGraphics, int posX, int posY, int scale, float mouseX, float mouseY, LivingEntity entity) {
        PoseStack poseStack = guiGraphics.pose();
        float f = (float)Math.atan(mouseX / 40.0f);
        float f1 = (float)Math.atan(mouseY / 40.0f);
        poseStack.pushPose();
        poseStack.translate((float)posX, (float)posY, 1050.0f);
        poseStack.scale(1.0f, 1.0f, -1.0f);
        poseStack.translate(0.0, 0.0, 1000.0);
        poseStack.scale((float)scale, (float)scale, (float)scale);
        Quaternionf quaternion = Axis.ZP.rotationDegrees(180.0f);
        Quaternionf quaternion1 = Axis.XP.rotationDegrees(f1 * 20.0f);
        quaternion.mul((Quaternionfc)quaternion1);
        poseStack.mulPose(quaternion);
        float f2 = entity.yBodyRot;
        float f3 = entity.yRotO;
        float f4 = entity.xRotO;
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + f * 20.0f;
        entity.yRotO = 180.0f + f * 40.0f;
        entity.xRotO = -f1 * 20.0f;
        entity.yHeadRot = entity.yRotO;
        entity.yHeadRotO = entity.yRotO;
        EntityRenderDispatcher entityrenderermanager = Minecraft.getInstance().getEntityRenderDispatcher();
        quaternion1.conjugate();
        entityrenderermanager.overrideCameraOrientation(quaternion1);
        entityrenderermanager.setRenderShadow(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        entityrenderermanager.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.endBatch();
        entityrenderermanager.setRenderShadow(true);
        entity.yBodyRot = f2;
        entity.yRotO = f3;
        entity.xRotO = f4;
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
        poseStack.popPose();
    }

    public void init() {
        String jobID;
        super.init();
        this.clearWidgets();
        int labelHeight = 9;
        LabelWidget nameLabel = new LabelWidget(this.leftPos + 65, this.topPos + 17, false, -1, 2, 0x404040);
        nameLabel.addLine(TextUtil.formatDemonName(this.spirit.getName().getString()));
        this.addRenderableWidget((GuiEventListener)nameLabel);
        if (this.spirit.getSpiritMaxAge() >= 0) {
            int agePercent = (int)Math.floor((float)this.spirit.getSpiritAge() / (float)this.spirit.getSpiritMaxAge() * 100.0f);
            LabelWidget ageLabel = new LabelWidget(this.leftPos + 65, this.topPos + 17 + labelHeight + 5, false, -1, 2, 0x404040);
            ageLabel.addLine(I18n.get((String)"gui.occultism.spirit.age", (Object[])new Object[]{agePercent}));
            this.addRenderableWidget((GuiEventListener)ageLabel);
        }
        if (!StringUtils.isBlank((CharSequence)(jobID = this.spirit.getJobID()))) {
            String[] lines;
            jobID = jobID.replace(":", ".");
            LabelWidget jobLabel = new LabelWidget(this.leftPos + 65, this.topPos + 17 + labelHeight + 5 + labelHeight + 5 + 5, false, -1, 2, 0x404040);
            String jobText = I18n.get((String)"gui.occultism.spirit.job", (Object[])new Object[]{I18n.get((String)("job." + jobID), (Object[])new Object[0])});
            for (String line : lines = WordUtils.wrap((String)jobText, (int)15, (String)"\n", (boolean)true).split("[\\r\\n]+", 2)) {
                jobLabel.addLine(String.valueOf(ChatFormatting.ITALIC) + line + String.valueOf(ChatFormatting.RESET));
            }
            this.addRenderableWidget((GuiEventListener)jobLabel);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.pose().pushPose();
        int scale = 30;
        SpiritGui.drawEntityToGui(guiGraphics, this.leftPos + 35, this.topPos + 65, scale, this.leftPos + 51 - x, this.topPos + 75 - 50 - y, (LivingEntity)this.spirit);
        guiGraphics.pose().popPose();
    }
}

