/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.audio;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.elements.audio.AudioElementBuilder;
import de.keksuccino.fancymenu.customization.element.elements.audio.AudioElementController;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.Trio;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AudioElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DrawableColor BACKGROUND_COLOR = DrawableColor.of(new Color(92, 166, 239));
    private static final long AUDIO_START_COOLDOWN_MS = 2000L;
    @NotNull
    protected PlayMode playMode = PlayMode.NORMAL;
    protected boolean loop = false;
    protected float volume = 1.0f;
    @NotNull
    protected SoundSource soundSource = SoundSource.MASTER;
    public List<AudioInstance> audios = new ArrayList<AudioInstance>();
    protected int currentAudioIndex = -1;
    @Nullable
    protected AudioInstance currentAudioInstance;
    protected IAudio currentAudio;
    protected boolean currentAudioStarted = false;
    protected long lastAudioStart = -1L;
    protected boolean cacheChecked = false;
    protected float lastControllerVolume = 1.0f;

    public AudioElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    protected List<Integer> getAlreadyPlayedShuffleAudios() {
        return this.getMemory().putPropertyIfAbsentAndGet("already_played_shuffle_audios", new ArrayList());
    }

    protected int getLastPlayedLoopShuffleAudio() {
        return this.getMemory().putPropertyIfAbsentAndGet("last_played_loop_shuffle_audio", -10000);
    }

    protected void setLastPlayedLoopShuffleAudio(int lastPlayedLoopShuffleAudio) {
        this.getMemory().putProperty("last_played_loop_shuffle_audio", lastPlayedLoopShuffleAudio);
    }

    public void renderTick() {
        if (AudioElement.isEditor()) {
            return;
        }
        boolean loadedFromCache = false;
        if (!this.cacheChecked) {
            if (AudioElementBuilder.CURRENT_AUDIO_CACHE.containsKey(this.getInstanceIdentifier())) {
                int cached = AudioElementBuilder.CURRENT_AUDIO_CACHE.get(this.getInstanceIdentifier()).getThird();
                if (this.audios.size() - 1 >= cached) {
                    this.currentAudioIndex = cached;
                    loadedFromCache = true;
                }
            }
            this.cacheChecked = true;
        }
        if (this.shouldRender()) {
            if (!loadedFromCache) {
                this.pickNextAudio();
            }
        } else if (loadedFromCache) {
            AudioElementBuilder.CURRENT_AUDIO_CACHE.get(this.getInstanceIdentifier()).getSecond().stop();
            AudioElementBuilder.CURRENT_AUDIO_CACHE.remove(this.getInstanceIdentifier());
            if (this.currentAudio != null && this.currentAudio.isReady() && this.currentAudio.isPlaying()) {
                this.currentAudio.stop();
            }
            return;
        }
        if (this.currentAudioIndex == -2) {
            return;
        }
        if (this.currentAudioIndex == -1) {
            return;
        }
        if (this.currentAudioInstance == null && this.currentAudioIndex >= 0 && this.audios.size() - 1 >= this.currentAudioIndex) {
            this.currentAudioInstance = this.audios.get(this.currentAudioIndex);
            if (this.currentAudioInstance != null) {
                this.currentAudio = this.currentAudioInstance.supplier.get();
                if (this.currentAudio != null) {
                    AudioElementBuilder.CURRENT_AUDIO_CACHE.put(this.getInstanceIdentifier(), Trio.of(this.currentAudioInstance.supplier, this.currentAudio, this.currentAudioIndex));
                }
            }
        }
        if (this.currentAudio != null) {
            boolean isOnCooldown;
            if (!this.shouldRender()) {
                if (this.currentAudio.isReady() && this.currentAudio.isPlaying()) {
                    this.currentAudio.stop();
                }
                return;
            }
            long now = System.currentTimeMillis();
            if (loadedFromCache) {
                if (this.currentAudio.isReady() && this.currentAudio.isPlaying()) {
                    this.lastAudioStart = now;
                    this.currentAudioStarted = true;
                }
                this.updateVolume();
                this.currentAudio.setSoundChannel(this.soundSource);
            }
            boolean bl = isOnCooldown = this.lastAudioStart + 2000L > now;
            if (!isOnCooldown && this.currentAudioInstance != null && !this.currentAudioStarted && this.currentAudio.isReady() && !this.currentAudio.isPlaying()) {
                this.lastAudioStart = now;
                this.updateVolume();
                this.currentAudio.setSoundChannel(this.soundSource);
                this.currentAudio.play();
                this.currentAudioStarted = true;
            }
            if (this.lastControllerVolume != this.getControllerVolume()) {
                this.updateVolume();
                this.lastControllerVolume = this.getControllerVolume();
            }
        }
    }

    protected void pickNextAudio() {
        if (this.audios.isEmpty()) {
            return;
        }
        if (this.currentAudioIndex == -2) {
            return;
        }
        if (this.currentAudioInstance != null) {
            if (this.currentAudio != null) {
                boolean isOnCooldown;
                long now = System.currentTimeMillis();
                boolean bl = isOnCooldown = this.lastAudioStart + 2000L > now;
                if (!(isOnCooldown || !this.currentAudioStarted || this.currentAudio.isReady() && this.currentAudio.isPlaying())) {
                    this.skipToNextAudio(false);
                }
            } else {
                LOGGER.warn("[FANCYMENU] Audio element was unable to load audio track! Skipping to next track, because track was NULL: " + this.currentAudioInstance.supplier.getSourceWithPrefix());
                this.skipToNextAudio(false);
            }
        } else {
            this.skipToNextAudio(false);
        }
    }

    public void skipToNextAudio(boolean forceRestartIfEndReached) {
        if (this.playMode == PlayMode.SHUFFLE) {
            List<Integer> indexes = this.buildShuffleIndexesList();
            if (this.loop && indexes.isEmpty() && !this.audios.isEmpty()) {
                this.getAlreadyPlayedShuffleAudios().clear();
                if (this.audios.size() == 1) {
                    this.setLastPlayedLoopShuffleAudio(-10000);
                }
                indexes = this.buildShuffleIndexesList();
            }
            if (!indexes.isEmpty()) {
                int pickedIndex = indexes.size() == 1 ? 0 : MathUtils.getRandomNumberInRange((int)0, (int)(indexes.size() - 1));
                this.currentAudioIndex = indexes.get(pickedIndex);
                this.getAlreadyPlayedShuffleAudios().add(this.currentAudioIndex);
                if (this.loop) {
                    this.setLastPlayedLoopShuffleAudio(this.currentAudioIndex);
                }
            } else {
                this.currentAudioIndex = -2;
                this.clearCacheForElement();
            }
        } else {
            ++this.currentAudioIndex;
            if (this.currentAudioIndex > this.audios.size() - 1) {
                int n = this.currentAudioIndex = this.loop ? 0 : -2;
                if (this.currentAudioIndex == -2) {
                    this.clearCacheForElement();
                }
            }
        }
        if (this.currentAudio != null && this.currentAudio.isReady()) {
            this.currentAudio.stop();
        }
        this.currentAudioInstance = null;
        this.currentAudio = null;
        this.currentAudioStarted = false;
        if (this.currentAudioIndex == -2 && forceRestartIfEndReached) {
            this.resetAudioElementKeepAudios();
        }
    }

    @NotNull
    protected List<Integer> buildShuffleIndexesList() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        if (this.playMode != PlayMode.SHUFFLE) {
            return indexes;
        }
        int i = 0;
        for (AudioInstance ignored : this.audios) {
            indexes.add(i);
            ++i;
        }
        indexes.removeIf(integer -> this.getAlreadyPlayedShuffleAudios().contains(integer));
        if (this.loop && this.getLastPlayedLoopShuffleAudio() != -10000 && indexes.contains(this.getLastPlayedLoopShuffleAudio())) {
            indexes.remove(this.getLastPlayedLoopShuffleAudio());
        }
        return indexes;
    }

    public void resetAudioElementKeepAudios() {
        if (this.currentAudio != null && this.currentAudio.isReady()) {
            this.currentAudio.stop();
        }
        this.currentAudioInstance = null;
        this.currentAudio = null;
        this.currentAudioStarted = false;
        this.currentAudioIndex = -1;
        this.lastAudioStart = -1L;
        this.getMemory().clear();
        this.clearCacheForElement();
    }

    public void clearCacheForElement() {
        if (AudioElementBuilder.CURRENT_AUDIO_CACHE.containsKey(this.getInstanceIdentifier())) {
            Trio<ResourceSupplier<IAudio>, IAudio, Integer> cache = AudioElementBuilder.CURRENT_AUDIO_CACHE.get(this.getInstanceIdentifier());
            if (cache != null && cache.getSecond().isReady()) {
                cache.getSecond().stop();
            }
            AudioElementBuilder.CURRENT_AUDIO_CACHE.remove(this.getInstanceIdentifier());
        }
    }

    public void setLooping(boolean loop, boolean resetElement) {
        this.loop = loop;
        if (resetElement) {
            this.resetAudioElementKeepAudios();
        }
    }

    public boolean isLooping() {
        return this.loop;
    }

    public void setPlayMode(@NotNull PlayMode mode, boolean resetElement) {
        this.playMode = Objects.requireNonNull(mode);
        if (resetElement) {
            this.resetAudioElementKeepAudios();
        }
    }

    @NotNull
    public PlayMode getPlayMode() {
        return this.playMode;
    }

    public void updateVolume() {
        float v = Math.max(0.0f, Math.min(1.0f, this.getControllerVolume() * this.volume));
        if (this.currentAudio != null) {
            this.currentAudio.setVolume(v);
        }
    }

    public void setVolume(float volume) {
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        this.volume = volume;
        this.updateVolume();
    }

    public float getVolume() {
        return this.volume;
    }

    public float getControllerVolume() {
        AudioElementController.AudioElementMeta meta = AudioElementController.getMeta(this.getInstanceIdentifier());
        if (meta != null) {
            return Math.max(0.0f, Math.min(1.0f, meta.volume));
        }
        return 1.0f;
    }

    public void setControllerVolume(float volume) {
        AudioElementController.AudioElementMeta meta = AudioElementController.getMeta(this.getInstanceIdentifier());
        if (meta == null) {
            meta = new AudioElementController.AudioElementMeta(this.getInstanceIdentifier(), 1.0f);
            AudioElementController.putMeta(this.getInstanceIdentifier(), meta);
        }
        meta.volume = Math.max(0.0f, Math.min(1.0f, volume));
        AudioElementController.syncChanges();
    }

    public void setSoundSource(@NotNull SoundSource soundSource) {
        this.soundSource = Objects.requireNonNull(soundSource);
        if (this.currentAudio != null) {
            this.currentAudio.setSoundChannel(soundSource);
        }
    }

    @NotNull
    public SoundSource getSoundSource() {
        return this.soundSource;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (AudioElement.isEditor()) {
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int w = this.getAbsoluteWidth();
            int h = this.getAbsoluteHeight();
            RenderSystem.enableBlend();
            graphics.fill(x, y, x + w, y + h, BACKGROUND_COLOR.getColorInt());
            graphics.enableScissor(x, y, x + w, y + h);
            Font font = Minecraft.getInstance().font;
            Component component = this.getDisplayName();
            int n = x + w / 2;
            int n2 = y + h / 2;
            Objects.requireNonNull(Minecraft.getInstance().font);
            graphics.drawCenteredString(font, component, n, n2 - 9 / 2, -1);
            graphics.disableScissor();
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    @Override
    public void renderTick_Inner_Stage_1() {
        this.renderTick();
    }

    public static enum PlayMode implements LocalizedCycleEnum<PlayMode>
    {
        NORMAL("normal"),
        SHUFFLE("shuffle");

        private final String name;

        private PlayMode(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.elements.audio.play_mode";
        }

        @Override
        @NotNull
        public Style getValueComponentStyle() {
            return (Style)LocalizedCycleEnum.WARNING_TEXT_STYLE.get();
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public PlayMode[] getValues() {
            return PlayMode.values();
        }

        @Override
        @Nullable
        public PlayMode getByNameInternal(@NotNull String name) {
            return PlayMode.getByName(name);
        }

        @Nullable
        public static PlayMode getByName(@NotNull String name) {
            for (PlayMode mode : PlayMode.values()) {
                if (!mode.getName().equals(name)) continue;
                return mode;
            }
            return null;
        }
    }

    public static class AudioInstance {
        @NotNull
        ResourceSupplier<IAudio> supplier;

        public AudioInstance(@NotNull ResourceSupplier<IAudio> supplier) {
            this.supplier = Objects.requireNonNull(supplier);
        }

        public static void serializeAllToExistingContainer(@NotNull List<AudioInstance> instances, @NotNull PropertyContainer container) {
            int i = 0;
            for (AudioInstance instance : instances) {
                container.putProperty("audio_instance_" + i, instance.supplier.getSourceWithPrefix());
                ++i;
            }
        }

        @NotNull
        public static List<AudioInstance> deserializeAllOfContainer(@NotNull PropertyContainer container) {
            ArrayList<AudioInstance> instances = new ArrayList<AudioInstance>();
            container.getProperties().forEach((key, value) -> {
                if (StringUtils.startsWith((CharSequence)key, (CharSequence)"audio_instance_")) {
                    instances.add(new AudioInstance(ResourceSupplier.audio(value)));
                }
            });
            return instances;
        }
    }
}

