/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.material.impl;

import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ResourceType;
import mekanism.common.tags.MekanismTags;
import mekanism.tools.common.ToolsTags;
import mekanism.tools.common.material.BaseMekanismMaterial;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class OsmiumMaterialDefaults
implements BaseMekanismMaterial {
    @Override
    public int getShieldDurability() {
        return 672;
    }

    @Override
    public float getAxeDamage() {
        return 8.0f;
    }

    @Override
    public float getAxeAtkSpeed() {
        return -3.3f;
    }

    public int getUses() {
        return 1024;
    }

    public float getSpeed() {
        return 4.0f;
    }

    public float getAttackDamageBonus() {
        return 4.0f;
    }

    public int getEnchantmentValue() {
        return 14;
    }

    @Override
    public float toughness() {
        return 3.0f;
    }

    @Override
    public int getDurabilityForType(@NotNull ArmorItem.Type armorType) {
        return switch (armorType) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.BOOTS -> 390;
            case ArmorItem.Type.LEGGINGS -> 450;
            case ArmorItem.Type.CHESTPLATE, ArmorItem.Type.BODY -> 480;
            case ArmorItem.Type.HELMET -> 330;
        };
    }

    @Override
    public int getDefense(@NotNull ArmorItem.Type armorType) {
        return switch (armorType) {
            case ArmorItem.Type.BOOTS -> 3;
            case ArmorItem.Type.LEGGINGS -> 6;
            case ArmorItem.Type.CHESTPLATE -> 8;
            case ArmorItem.Type.HELMET -> 4;
            default -> 0;
        };
    }

    @Override
    @NotNull
    public String getRegistryPrefix() {
        return "osmium";
    }

    @NotNull
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return ToolsTags.Blocks.INCORRECT_FOR_OSMIUM_TOOL;
    }

    @Override
    @NotNull
    public Holder<SoundEvent> equipSound() {
        return SoundEvents.ARMOR_EQUIP_IRON;
    }

    @NotNull
    public Ingredient getRepairIngredient() {
        return Ingredient.of((TagKey)((TagKey)MekanismTags.Items.PROCESSED_RESOURCES.get((Object)ResourceType.INGOT, (Object)PrimaryResource.OSMIUM)));
    }

    @Override
    public float knockbackResistance() {
        return 0.1f;
    }
}

