/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.client.recipe_viewer.jei;

import mekanism.client.recipe_viewer.jei.JEIAliasHelper;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.jei.RecipeRegistryHelper;
import mekanism.tools.client.recipe_viewer.aliases.ToolsAliasMapping;
import mekanism.tools.common.item.ItemMekanismShield;
import mekanism.tools.common.registries.ToolsItems;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ToolsJEI
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"mekanismtools", (String)"jei_plugin");
    }

    public void registerIngredientAliases(@NotNull IIngredientAliasRegistration registration) {
        new ToolsAliasMapping().addAliases(new JEIAliasHelper(registration));
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        if (MekanismJEI.shouldLoad()) {
            for (Holder toolsItem : ToolsItems.ITEMS.getEntries()) {
                RecipeRegistryHelper.addAnvilRecipes((IRecipeRegistration)registry, (ItemLike)((ItemLike)toolsItem.value()), item -> {
                    if (item instanceof ItemMekanismShield) {
                        ItemMekanismShield shieldItem = (ItemMekanismShield)((Object)item);
                        return shieldItem.getRepairMaterial().getItems();
                    }
                    if (item instanceof ArmorItem) {
                        ArmorItem armorItem = (ArmorItem)item;
                        return ((Ingredient)((ArmorMaterial)armorItem.getMaterial().value()).repairIngredient().get()).getItems();
                    }
                    if (item instanceof TieredItem) {
                        TieredItem tieredItem = (TieredItem)item;
                        return tieredItem.getTier().getRepairIngredient().getItems();
                    }
                    return null;
                });
            }
        }
    }
}

