/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.containers;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.blocks.LaserNode;
import com.direwolf20.laserio.common.containers.customhandler.CardItemHandler;
import com.direwolf20.laserio.common.containers.customhandler.FilterBasicHandler;
import com.direwolf20.laserio.common.containers.customhandler.FilterCountHandler;
import com.direwolf20.laserio.common.containers.customslot.CardHolderSlot;
import com.direwolf20.laserio.common.containers.customslot.CardItemSlot;
import com.direwolf20.laserio.common.containers.customslot.CardOverclockSlot;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.items.CardHolder;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.setup.Registration;
import com.direwolf20.laserio.util.CardHolderItemStackHandler;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class CardItemContainer
extends AbstractContainerMenu {
    public static final int SLOTS = 2;
    public static final int FILTERSLOTS = 15;
    public CardItemHandler handler;
    public FilterBasicHandler filterHandler;
    public ItemStack cardItem;
    public Player playerEntity;
    protected IItemHandler playerInventory;
    public BlockPos sourceContainer = BlockPos.ZERO;
    public byte direction = (byte)-1;
    public ItemStack cardHolder;
    public CardHolderItemStackHandler cardHolderHandler;
    public UUID cardHolderUUID;

    protected CardItemContainer(@Nullable MenuType<?> pMenuType, int pContainerId) {
        super(pMenuType, pContainerId);
    }

    public CardItemContainer(int windowId, Inventory playerInventory, Player player, RegistryFriendlyByteBuf extraData) {
        this(windowId, playerInventory, player, (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)extraData));
        this.direction = extraData.readByte();
        this.cardHolder = LaserNode.findCardHolders(player);
    }

    public CardItemContainer(int windowId, Inventory playerInventory, Player player, ItemStack cardItem) {
        super((MenuType)Registration.CardItem_Container.get(), windowId);
        this.playerEntity = player;
        this.handler = BaseCard.getInventory(cardItem);
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.cardItem = cardItem;
        if (this.handler != null) {
            this.addSlotRange((IItemHandler)this.handler, 0, 80, 5, 1, 18);
            this.addSlotRange((IItemHandler)this.handler, 1, 153, 5, 1, 18);
            this.addSlotBox((IItemHandler)this.filterHandler, 0, 44, 25, 5, 18, 3, 18);
            this.toggleFilterSlots();
        }
        this.cardHolder = LaserNode.findCardHolders(player);
        if (!this.cardHolder.isEmpty()) {
            this.cardHolderHandler = new CardHolderItemStackHandler(15, this.cardHolder);
            this.addSlotBox((IItemHandler)this.cardHolderHandler, 0, -92, 32, 5, 18, 3, 18);
            this.cardHolderUUID = CardHolder.getUUID(this.cardHolder);
        }
        this.layoutPlayerInventorySlots(8, 84);
    }

    public CardItemContainer(int windowId, Inventory playerInventory, Player player, BlockPos sourcePos, ItemStack cardItem, byte direction) {
        this(windowId, playerInventory, player, cardItem);
        this.sourceContainer = sourcePos;
        this.direction = direction;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 2 && slotId < 17) {
            return;
        }
        if (slotId >= 0) {
            if (this.slots.get(slotId) instanceof CardHolderSlot) {
                ItemStack carriedItem = this.getCarried();
                ItemStack stackInSlot = ((Slot)this.slots.get(slotId)).getItem();
                if (!(stackInSlot.getMaxStackSize() != 1 || stackInSlot.getCount() <= 1 || carriedItem.isEmpty() || stackInSlot.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)carriedItem, (ItemStack)stackInSlot))) {
                    return;
                }
            } else {
                ItemStack slotItem = ((Slot)this.slots.get(slotId)).getItem();
                if (slotItem.getItem() instanceof CardHolder) {
                    return;
                }
            }
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public void getFilterHandler() {
        ItemStack filterStack = ((Slot)this.slots.get(0)).getItem();
        this.filterHandler = filterStack.getItem() instanceof FilterBasic ? FilterBasic.getInventory(filterStack) : (filterStack.getItem() instanceof FilterCount ? FilterCount.getInventory(filterStack) : new FilterBasicHandler(15, filterStack));
    }

    public void toggleFilterSlots() {
        this.getFilterHandler();
        this.updateFilterSlots((IItemHandler)this.filterHandler, 0, 44, 25, 5, 18, 3, 18);
    }

    public boolean stillValid(Player playerIn) {
        if (this.cardHolder.isEmpty() && this.cardHolderUUID != null) {
            Inventory playerInventory = this.playerEntity.getInventory();
            for (int i = 0; i < playerInventory.items.size(); ++i) {
                ItemStack itemStack = (ItemStack)playerInventory.items.get(i);
                if (!(itemStack.getItem() instanceof CardHolder) || !CardHolder.getUUID(itemStack).equals(this.cardHolderUUID)) continue;
                this.cardHolder = itemStack;
                break;
            }
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.handler.getStackInSlot(0), (ItemStack)this.filterHandler.stack)) {
            this.handler.setStackInSlot(0, this.filterHandler.stack);
        }
        if (this.sourceContainer.equals((Object)BlockPos.ZERO)) {
            return playerIn.getMainHandItem().equals(this.cardItem) || playerIn.getOffhandItem().equals(this.cardItem);
        }
        return true;
    }

    public int getStackSize(int slot) {
        ItemStack filterStack = this.filterHandler.stack;
        if (slot >= 2 && slot < 17 && this.slots.get(slot) instanceof FilterBasicSlot && filterStack.getItem() instanceof FilterCount) {
            return FilterCount.getSlotCount(filterStack, slot - 2);
        }
        return this.filterHandler.getStackInSlot(slot - 2).getCount();
    }

    public boolean canTakeItemForPickAll(ItemStack itemStack, Slot slot) {
        return !(slot instanceof CardHolderSlot);
    }

    protected boolean moveItemStackTo(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        boolean flag = false;
        int i = pStartIndex;
        if (pReverseDirection) {
            i = pEndIndex - 1;
        }
        if (pStack.isStackable()) {
            while (!pStack.isEmpty() && (pReverseDirection ? i >= pStartIndex : i < pEndIndex)) {
                Slot slot = (Slot)this.slots.get(i);
                ItemStack itemstack = slot.getItem();
                if (!itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)pStack, (ItemStack)itemstack)) {
                    int k;
                    int j = itemstack.getCount() + pStack.getCount();
                    if (j <= (k = slot.getMaxStackSize(itemstack))) {
                        pStack.setCount(0);
                        itemstack.setCount(j);
                        slot.setChanged();
                        slot.setByPlayer(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < k) {
                        pStack.shrink(k - itemstack.getCount());
                        itemstack.setCount(k);
                        slot.setChanged();
                        slot.setByPlayer(itemstack);
                        flag = true;
                    }
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!pStack.isEmpty()) {
            i = pReverseDirection ? pEndIndex - 1 : pStartIndex;
            while (pReverseDirection ? i >= pStartIndex : i < pEndIndex) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(pStack)) {
                    int l = slot1.getMaxStackSize(pStack);
                    slot1.setByPlayer(pStack.split(Math.min(pStack.getCount(), l)));
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        if (this.cardItem.getCount() > 1) {
            return ItemStack.EMPTY;
        }
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            if (ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)this.cardItem)) {
                return ItemStack.EMPTY;
            }
            if (index < 2) {
                if (!this.cardHolder.isEmpty()) {
                    if (this.moveItemStackTo(stack, 17, 32, false)) {
                        slot.setByPlayer(stack);
                        return ItemStack.EMPTY;
                    }
                    if (this.moveItemStackTo(stack, 32, 68, true)) {
                        slot.setByPlayer(stack);
                        return ItemStack.EMPTY;
                    }
                } else if (this.moveItemStackTo(stack, 17, 53, true)) {
                    slot.setByPlayer(stack);
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack, itemstack);
            } else if (index < 2 || index >= 17) {
                ItemStack currentStack = slot.getItem().copy();
                if (((Slot)this.slots.get(0)).mayPlace(currentStack) || ((Slot)this.slots.get(1)).mayPlace(currentStack)) {
                    if (this.moveItemStackTo(stack, 0, 2, false)) {
                        slot.setByPlayer(stack);
                        return ItemStack.EMPTY;
                    }
                } else if (((Slot)this.slots.get(0)).getItem().getItem() instanceof BaseFilter) {
                    if (!(((Slot)this.slots.get(0)).getItem().getItem() instanceof FilterCount)) {
                        currentStack.setCount(1);
                    }
                    for (int i = 2; i < 17; ++i) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)((Slot)this.slots.get(i)).getItem(), (ItemStack)currentStack)) continue;
                        return ItemStack.EMPTY;
                    }
                    if (this.moveItemStackTo(currentStack, 2, 17, false)) {
                        slot.setByPlayer(stack);
                        return ItemStack.EMPTY;
                    }
                }
                if (this.filterHandler instanceof FilterCountHandler) {
                    ((FilterCountHandler)this.filterHandler).syncSlots();
                }
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setByPlayer(stack);
                slot.setChanged();
            }
            if (stack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, stack);
        }
        return itemstack;
    }

    protected void updateFilterSlots(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            for (int i = 0; i < horAmount; ++i) {
                if ((!(handler instanceof CardItemHandler) || index != 0) && handler instanceof FilterBasicHandler) {
                    this.slots.set(index + 2, (Object)new FilterBasicSlot(handler, index, x, y, ((Slot)this.slots.get(0)).getItem().getItem() instanceof FilterCount));
                    ((Slot)this.slots.get((int)(index + 2))).index = index + 2;
                }
                x += dx;
                ++index;
            }
            y += dy;
            x -= dx * horAmount;
        }
    }

    protected int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            if (handler instanceof CardItemHandler && index == 0) {
                this.addSlot((Slot)new CardItemSlot(handler, this, index, x, y));
            } else if (handler instanceof CardItemHandler && index == 1) {
                this.addSlot((Slot)new CardOverclockSlot(handler, index, x, y));
            } else if (handler instanceof FilterBasicHandler) {
                this.addSlot((Slot)new FilterBasicSlot(handler, index, x, y, ((Slot)this.slots.get(0)).getItem().getItem() instanceof FilterCount));
            } else if (handler != null && handler.getSlots() == 15) {
                this.addSlot((Slot)new CardHolderSlot(handler, index, x, y));
            } else {
                this.addSlot((Slot)new SlotItemHandler(handler, index, x, y));
            }
            x += dx;
            ++index;
        }
        return index;
    }

    protected int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    protected void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public void removed(Player playerIn) {
        BlockEntity blockEntity;
        Level world = playerIn.level();
        if (!world.isClientSide && !this.sourceContainer.equals((Object)BlockPos.ZERO) && (blockEntity = world.getBlockEntity(this.sourceContainer)) instanceof LaserNodeBE) {
            ((LaserNodeBE)blockEntity).updateThisNode();
        }
        super.removed(playerIn);
    }
}

