/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.unrealdinnerbone.jamd.ConfigCodec;
import com.unrealdinnerbone.jamd.JAMD;
import com.unrealdinnerbone.jamd.OresCodec;
import com.unrealdinnerbone.jamd.api.FeatureTypeRegistry;
import com.unrealdinnerbone.jamd.block.base.PortalTileEntity;
import com.unrealdinnerbone.trenzalore.api.registry.RegistryEntry;
import com.unrealdinnerbone.trenzalore.lib.RLUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldType {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LoggerFactory.getLogger(WorldType.class);
    public static final List<WorldType> TYPES = new ArrayList<WorldType>();
    private final String name;
    private final KeySet key;
    private final RegistryEntry<Block> block;
    private final RegistryEntry<BlockItem> item;
    private final RegistryEntry<BlockEntityType<PortalTileEntity>> blockEntity;
    private final TagKey<ConfiguredFeature<?, ?>> ingoredConfigFeatures;
    private final TagKey<PlacedFeature> ingoredPlaceFeatures;
    private final Path configPath;
    private final TagKey<Biome> biomeTag;

    public WorldType(String name, RegistryEntry<Block> block, RegistryEntry<BlockItem> item, RegistryEntry<BlockEntityType<PortalTileEntity>> blockEntity, TagKey<Biome> biomeTag) {
        this.name = name;
        this.key = KeySet.of(RLUtils.rl((String)"jamd", (String)name));
        this.block = block;
        this.item = item;
        this.blockEntity = blockEntity;
        this.biomeTag = biomeTag;
        this.ingoredConfigFeatures = TagKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)RLUtils.rl((String)"jamd", (String)name));
        this.ingoredPlaceFeatures = TagKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)RLUtils.rl((String)"jamd", (String)name));
        this.configPath = JAMD.CONFIG_FOLDER.resolve(name + ".json");
        TYPES.add(this);
    }

    public RegistryEntry<Block> getBlock() {
        return this.block;
    }

    public RegistryEntry<BlockEntityType<PortalTileEntity>> getBlockEntity() {
        return this.blockEntity;
    }

    public RegistryEntry<BlockItem> getItem() {
        return this.item;
    }

    public KeySet getKey() {
        return this.key;
    }

    public TagKey<ConfiguredFeature<?, ?>> getIgnoredFeatures() {
        return this.ingoredConfigFeatures;
    }

    public TagKey<PlacedFeature> getIgnoredPlaceFeatures() {
        return this.ingoredPlaceFeatures;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldType worldType = (WorldType)o;
        return Objects.equals(this.name, worldType.name);
    }

    public String getName() {
        return this.name;
    }

    public TagKey<Biome> getBiomeTag() {
        return this.biomeTag;
    }

    public Path getConfigPath() {
        return this.configPath;
    }

    public void exportIfNotExist(MinecraftServer server) throws IllegalStateException, IOException {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            this.export(server);
        }
    }

    public void export(MinecraftServer server) throws IllegalStateException, IOException {
        ArrayList loggedTypes = new ArrayList();
        ArrayList oresCodecs = new ArrayList();
        List<PlacedFeature> placedFeatures = this.getFeatures(server);
        for (PlacedFeature placedFeature : placedFeatures) {
            boolean b = server.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).wrapAsHolder((Object)placedFeature).is(this.ingoredPlaceFeatures);
            if (!b && !placedFeature.feature().is(this.ingoredConfigFeatures)) {
                RegistryAccess.Frozen frozen = server.registryAccess();
                ConfiguredFeature configuredFeatureReference = (ConfiguredFeature)placedFeature.feature().value();
                Feature feature1 = configuredFeatureReference.feature();
                ResourceLocation key1 = frozen.registryOrThrow(Registries.FEATURE).getKey((Object)feature1);
                FeatureTypeRegistry.getFeatureType(key1).ifPresentOrElse(iFeatureTypeCompact -> {
                    try {
                        oresCodecs.add(iFeatureTypeCompact.getOreCodec(configuredFeatureReference.config(), placedFeature.placement()));
                    }
                    catch (ClassCastException e) {
                        LOGGER.error("Failed to parse ore Wrong Ore Config?", (Throwable)e);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to parse ore", (Throwable)e);
                    }
                }, () -> {
                    if (!loggedTypes.contains(key1.toString())) {
                        loggedTypes.add(key1.toString());
                        LOGGER.debug("No Feature Mapping for: {}", (Object)key1);
                    }
                });
            }
            ArrayList<OresCodec> workedOres = new ArrayList<OresCodec>();
            for (OresCodec oresCodec : oresCodecs) {
                DataResult jsonElementDataResult = OresCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)oresCodec);
                if (jsonElementDataResult.result().isPresent()) {
                    workedOres.add(oresCodec);
                    continue;
                }
                LOGGER.error("Failed to encode: {}", jsonElementDataResult.error().get());
            }
            DataResult result = ConfigCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new ConfigCodec(1, false, workedOres));
            if (result.result().isPresent()) {
                if (!Files.exists(JAMD.CONFIG_FOLDER, new LinkOption[0])) {
                    Files.createDirectories(JAMD.CONFIG_FOLDER, new FileAttribute[0]);
                }
                Files.writeString(this.configPath, (CharSequence)GSON.toJson((JsonElement)result.result().get()), new OpenOption[0]);
                continue;
            }
            LOGGER.error("Failed to load config: {}", result.error().get());
        }
    }

    public String getAdvancementTitleKey() {
        return "advancements.jamd." + this.name + ".title";
    }

    public String getAdvancementDescriptionKey() {
        return "advancements.jamd." + this.name + ".description";
    }

    public List<PlacedFeature> getFeatures(MinecraftServer server) {
        ArrayList<PlacedFeature> features = new ArrayList<PlacedFeature>();
        HolderLookup.RegistryLookup biomeRegistryLookup = (HolderLookup.RegistryLookup)server.registryAccess().lookup(Registries.BIOME).orElseThrow();
        for (Holder.Reference biomeReference : biomeRegistryLookup.listElements().toList()) {
            Set placedFeatures = (Set)((Biome)biomeReference.value()).getGenerationSettings().featureSet.get();
            for (PlacedFeature placedFeature : placedFeatures) {
                if (!biomeReference.is(this.biomeTag) || features.contains(placedFeature)) continue;
                features.add(placedFeature);
            }
        }
        return features;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public record KeySet(ResourceKey<Level> level, ResourceKey<DimensionType> dimensionType, ResourceKey<Biome> biome) {
        private static KeySet of(ResourceLocation id) {
            return new KeySet((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id), (ResourceKey<DimensionType>)ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)id), (ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)id));
        }
    }
}

