/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd;

import com.mojang.serialization.MapCodec;
import com.unrealdinnerbone.jamd.WorldType;
import com.unrealdinnerbone.jamd.block.EndBlockEntity;
import com.unrealdinnerbone.jamd.block.EndPortalBlock;
import com.unrealdinnerbone.jamd.block.NetherBlockEntity;
import com.unrealdinnerbone.jamd.block.NetherPortalBlock;
import com.unrealdinnerbone.jamd.block.OverworldBlockEntity;
import com.unrealdinnerbone.jamd.block.OverworldPortalBlock;
import com.unrealdinnerbone.jamd.block.base.PortalTileEntity;
import com.unrealdinnerbone.jamd.world.CustomFlatLevelSource;
import com.unrealdinnerbone.trenzalore.api.platform.services.IRegistry;
import com.unrealdinnerbone.trenzalore.api.registry.Regeneration;
import com.unrealdinnerbone.trenzalore.api.registry.RegistryEntry;
import com.unrealdinnerbone.trenzalore.api.registry.RegistryObjects;
import com.unrealdinnerbone.trenzalore.lib.CreativeTabs;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class JAMDRegistry
implements IRegistry {
    private static final RegistryObjects<Block> BLOCKS = Regeneration.create((ResourceKey)Registries.BLOCK);
    private static final RegistryObjects<Item> ITEMS = Regeneration.create((ResourceKey)Registries.ITEM);
    private static final RegistryObjects<BlockEntityType<?>> TILES = Regeneration.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE);
    private static final RegistryObjects<MapCodec<? extends ChunkGenerator>> CHUNK_GENERATORS = Regeneration.create((ResourceKey)Registries.CHUNK_GENERATOR);
    public static final RegistryEntry<MapCodec<? extends ChunkGenerator>> CUSTOM_FLAT_LEVEL_SOURCE = CHUNK_GENERATORS.register("mining", () -> CustomFlatLevelSource.CODEC);
    public static final WorldType OVERWORLD = JAMDRegistry.of("mining", "portal_block", "portal", OverworldPortalBlock::new, OverworldBlockEntity::new, (TagKey<Biome>)BiomeTags.IS_OVERWORLD);
    public static final WorldType NETHER = JAMDRegistry.of("nether", "nether_portal", "nether_portal", NetherPortalBlock::new, NetherBlockEntity::new, (TagKey<Biome>)BiomeTags.IS_NETHER);
    public static final WorldType END = JAMDRegistry.of("end", "end_portal", "end_portal", EndPortalBlock::new, EndBlockEntity::new, (TagKey<Biome>)BiomeTags.IS_END);

    private static WorldType of(String name, String blockName, String tileName, Supplier<Block> blockSupplier, BiFunction<BlockPos, BlockState, PortalTileEntity> tileSupplier, TagKey<Biome> biomeTagKey) {
        RegistryEntry block = BLOCKS.register(blockName, blockSupplier);
        return new WorldType(name, (RegistryEntry<Block>)block, (RegistryEntry<BlockItem>)ITEMS.register(blockName, () -> new BlockItem((Block)block.get(), new Item.Properties())), (RegistryEntry<BlockEntityType<PortalTileEntity>>)TILES.register(tileName, () -> Regeneration.createBlockEntityType((BiFunction)tileSupplier, (Block[])new Block[]{(Block)block.get()})), biomeTagKey);
    }

    public void afterRegistered() {
        Regeneration.addItemsToCreateTab((ResourceKey)CreativeTabs.FUNCTIONAL_BLOCKS, List.of(OVERWORLD.getItem(), NETHER.getItem(), END.getItem()));
    }

    public List<RegistryObjects<?>> getRegistryObjects() {
        return List.of(BLOCKS, ITEMS, TILES, CHUNK_GENERATORS);
    }

    public String getModID() {
        return "jamd";
    }
}

