/*
 * Decompiled with CFR 0.152.
 */
package com.vsngarcia.client.gui;

import com.vsngarcia.ElevatorBlockBase;
import com.vsngarcia.client.gui.FacingButton;
import com.vsngarcia.client.gui.FacingControllerWrapper;
import com.vsngarcia.level.ElevatorBlockEntityBase;
import com.vsngarcia.level.ElevatorContainer;
import com.vsngarcia.network.ClientPacketSender;
import com.vsngarcia.network.client.RemoveCamoPacket;
import com.vsngarcia.network.client.SetArrowPacket;
import com.vsngarcia.network.client.SetDirectionalPacket;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.properties.Property;

public class ElevatorScreen
extends AbstractContainerScreen<ElevatorContainer> {
    private final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"elevatorid", (String)"textures/gui/elevator_gui.png");
    private final ElevatorBlockEntityBase tile;
    private final Direction playerFacing;
    private final ClientPacketSender packetSender;
    private Checkbox dirButton;
    private Checkbox hideArrowButton;
    private Button resetCamoButton;
    private FacingControllerWrapper facingController;

    public ElevatorScreen(ElevatorContainer container, Inventory inv, Component titleIn, ClientPacketSender pktSender) {
        super((AbstractContainerMenu)container, inv, titleIn);
        this.imageWidth = 200;
        this.imageHeight = 100;
        this.tile = container.getTile();
        this.playerFacing = container.getPlayerFacing();
        this.packetSender = pktSender;
    }

    public void init() {
        super.init();
        this.dirButton = Checkbox.builder((Component)Component.translatable((String)"screen.elevatorid.elevator.directional"), (Font)this.font).pos(this.leftPos + 8, this.topPos + 25).selected(((Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlockBase.DIRECTIONAL)).booleanValue()).onValueChange((checkbox, selected) -> this.packetSender.sendToServer(new SetDirectionalPacket(selected, this.tile.getBlockPos()))).build();
        this.addRenderableWidget((GuiEventListener)this.dirButton);
        this.hideArrowButton = Checkbox.builder((Component)Component.translatable((String)"screen.elevatorid.elevator.hide_arrow"), (Font)this.font).pos(this.leftPos + 8, this.topPos + 50).selected((Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlockBase.SHOW_ARROW) == false).onValueChange((checkbox, selected) -> this.packetSender.sendToServer(new SetArrowPacket(!selected, this.tile.getBlockPos()))).build();
        this.hideArrowButton.visible = (Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlockBase.DIRECTIONAL);
        this.addRenderableWidget((GuiEventListener)this.hideArrowButton);
        this.facingController = new FacingControllerWrapper(this.leftPos + 120, this.topPos + 20, this.tile.getBlockPos(), this.playerFacing, this.packetSender);
        this.facingController.getButtons().forEach(x$0 -> {
            FacingButton cfr_ignored_0 = (FacingButton)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.facingController.getButtons().forEach(button -> {
            button.visible = (Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlockBase.DIRECTIONAL);
            button.active = this.tile.getBlockState().getValue((Property)ElevatorBlockBase.FACING) != button.direction;
        });
        this.resetCamoButton = Button.builder((Component)Component.translatable((String)"screen.elevatorid.elevator.reset_camo"), but -> this.packetSender.sendToServer(new RemoveCamoPacket(this.tile.getBlockPos()))).pos(this.leftPos + 8, this.topPos + 75).size(110, 20).build();
        this.addRenderableWidget((GuiEventListener)this.resetCamoButton);
        this.resetCamoButton.active = this.tile.getHeldState() != null;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void containerTick() {
        super.containerTick();
        this.dirButton.selected = (Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlockBase.DIRECTIONAL);
        this.facingController.getButtons().forEach(button -> {
            button.visible = (Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlockBase.DIRECTIONAL);
            button.active = this.tile.getBlockState().getValue((Property)ElevatorBlockBase.FACING) != button.direction;
        });
        this.hideArrowButton.visible = (Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlockBase.DIRECTIONAL);
        this.hideArrowButton.selected = (Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlockBase.SHOW_ARROW) == false;
        this.resetCamoButton.active = this.tile.getHeldState() != null;
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int mouseX, int mouseY) {
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI_TEXTURE, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 8, 8, 0xE0E0E0);
    }
}

