/*
 * Decompiled with CFR 0.152.
 */
package com.vsngarcia;

import com.vsngarcia.Config;
import com.vsngarcia.ElevatorBlockBase;
import com.vsngarcia.network.ClientPacketSender;
import com.vsngarcia.network.TeleportPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class ElevatorHandler {
    private static boolean lastSneaking;
    private static boolean lastJumping;

    public static void handleInput(ClientPacketSender sender) {
        boolean jumping;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isSpectator() || !player.isAlive() || player.input == null) {
            return;
        }
        boolean sneaking = player.input.shiftKeyDown;
        if (lastSneaking != sneaking) {
            lastSneaking = sneaking;
            if (sneaking) {
                ElevatorHandler.tryTeleport(player, Direction.DOWN, sender);
            }
        }
        if (lastJumping != (jumping = player.input.jumping)) {
            lastJumping = jumping;
            if (jumping) {
                ElevatorHandler.tryTeleport(player, Direction.UP, sender);
            }
        }
    }

    private static void tryTeleport(LocalPlayer player, Direction facing, ClientPacketSender sender) {
        block3: {
            ElevatorBlockBase toElevator;
            Level world = player.level();
            BlockPos fromPos = ElevatorHandler.getOriginElevator(player);
            if (fromPos == null) {
                return;
            }
            BlockPos.MutableBlockPos toPos = fromPos.mutable();
            ElevatorBlockBase fromElevator = TeleportPacket.getElevator(world.getBlockState(fromPos));
            if (fromElevator == null) {
                return;
            }
            do {
                toPos.setY(toPos.getY() + facing.getStepY());
                if (world.isOutsideBuildHeight((BlockPos)toPos) || Math.abs(toPos.getY() - fromPos.getY()) > (Integer)Config.GENERAL.range.get()) break block3;
            } while ((toElevator = TeleportPacket.getElevator(world.getBlockState((BlockPos)toPos))) == null || !TeleportPacket.isValidPos((BlockGetter)world, (BlockPos)toPos) || ((Boolean)Config.GENERAL.sameColor.get()).booleanValue() && fromElevator.getColor() != toElevator.getColor());
            sender.sendToServer(new TeleportPacket(fromPos, (BlockPos)toPos));
        }
    }

    private static BlockPos getOriginElevator(LocalPlayer player) {
        BlockPos pos = player.blockPosition();
        for (int i = 0; i < 3; ++i) {
            if (TeleportPacket.getElevator(player.level().getBlockState(pos)) != null) {
                return pos;
            }
            pos = pos.below();
        }
        return null;
    }
}

