/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.recipe;

import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.machines.recipe.ProxyableMachineRecipeType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.datagen.api.RecipeHelper;

public final class ComposterMachineRecipeType
extends ProxyableMachineRecipeType {
    public ComposterMachineRecipeType(ResourceLocation id) {
        super(id);
    }

    private RecipeHolder<MachineRecipe> generate(Item item, float chance) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        ResourceLocation id = EI.id("composter/generated/%s/%s_to_bonemeal".formatted(itemId.getNamespace(), itemId.getPath()));
        MachineRecipeBuilder recipe = new MachineRecipeBuilder((MachineRecipeType)this, 2, 100);
        int amountNeeded = Math.max(1, (int)Math.floor(8.0f / chance / 2.0f));
        recipe.addItemInput((ItemLike)item, amountNeeded);
        recipe.addItemOutput(Items.BONE_MEAL, 2);
        return new RecipeHolder(id, (Recipe)RecipeHelper.getActualRecipe(recipe));
    }

    protected void fillRecipeList(Level level) {
        this.recipeList.addAll(this.getManagerRecipes(level));
        for (Item item : BuiltInRegistries.ITEM) {
            float chance = ComposterBlock.getValue((ItemStack)item.getDefaultInstance());
            if (!(chance > 0.0f)) continue;
            RecipeHolder<MachineRecipe> recipe = this.generate(item, chance);
            this.recipeList.add(recipe);
        }
    }
}

