/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.recipe;

import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.machines.recipe.ProxyableMachineRecipeType;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.datagen.api.RecipeHelper;

public final class CanningMachineRecipeType
extends ProxyableMachineRecipeType {
    public CanningMachineRecipeType(ResourceLocation id) {
        super(id);
    }

    private RecipeHolder<MachineRecipe> generateCannedFood(Item foodItem, FoodProperties food) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)foodItem);
        ResourceLocation id = EI.id("canning_machine/generated/canned_food/%s/%s".formatted(itemId.getNamespace(), itemId.getPath()));
        MachineRecipeBuilder recipe = new MachineRecipeBuilder((MachineRecipeType)this, 2, 100);
        int count = (int)Math.ceil((double)food.nutrition() / 2.0);
        recipe.addItemInput(EIItems.TIN_CAN, count);
        recipe.addItemInput((ItemLike)foodItem, 1);
        recipe.addItemOutput(EIItems.CANNED_FOOD, count);
        ItemStack remainingItemStack = ItemStack.EMPTY;
        if (food.usingConvertsTo().isPresent()) {
            remainingItemStack = (ItemStack)food.usingConvertsTo().get();
        } else {
            ItemStack foodItemStack = foodItem.getDefaultInstance();
            if (foodItemStack.hasCraftingRemainingItem()) {
                remainingItemStack = foodItemStack.getCraftingRemainingItem();
            }
        }
        recipe.addItemOutput(remainingItemStack.getItem(), remainingItemStack.getCount());
        return new RecipeHolder(id, (Recipe)RecipeHelper.getActualRecipe(recipe));
    }

    private List<RecipeHolder<MachineRecipe>> buildCannedFood() {
        ArrayList recipes = Lists.newArrayList();
        for (Item item : BuiltInRegistries.ITEM) {
            ItemStack itemStack;
            FoodProperties foodProperties;
            if (item == EIItems.CANNED_FOOD.asItem() || item == Items.OMINOUS_BOTTLE || (foodProperties = item.getFoodProperties(itemStack = item.getDefaultInstance(), null)) == null) continue;
            FoodProperties food = item.getFoodProperties(item.getDefaultInstance(), null);
            recipes.add(this.generateCannedFood(item, food));
        }
        return recipes;
    }

    private RecipeHolder<MachineRecipe> generateFillingBucket(FluidStack fluidStack, ResourceLocation itemId, Item fullItem, Item emptyItem) {
        ResourceLocation id = EI.id("canning_machine/generated/filling/%s/%s".formatted(itemId.getNamespace(), itemId.getPath()));
        MachineRecipeBuilder recipe = new MachineRecipeBuilder((MachineRecipeType)this, 2, 100);
        recipe.addFluidInput(fluidStack.getFluid(), fluidStack.getAmount());
        recipe.addItemInput((ItemLike)emptyItem, 1);
        recipe.addItemOutput(fullItem, 1);
        return new RecipeHolder(id, (Recipe)RecipeHelper.getActualRecipe(recipe));
    }

    private RecipeHolder<MachineRecipe> generateEmptyingBucket(FluidStack fluidStack, ResourceLocation itemId, Item fullItem, Item emptyItem) {
        ResourceLocation id = EI.id("canning_machine/generated/emptying/%s/%s".formatted(itemId.getNamespace(), itemId.getPath()));
        MachineRecipeBuilder recipe = new MachineRecipeBuilder((MachineRecipeType)this, 2, 100);
        recipe.addItemInput((ItemLike)fullItem, 1);
        recipe.addItemOutput(emptyItem, 1);
        recipe.addFluidOutput(fluidStack.getFluid(), fluidStack.getAmount());
        return new RecipeHolder(id, (Recipe)RecipeHelper.getActualRecipe(recipe));
    }

    private List<RecipeHolder<MachineRecipe>> buildBucket() {
        ArrayList recipes = Lists.newArrayList();
        HashSet uniqueFluids = Sets.newHashSet();
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            Item fullItem;
            Fluid processedFluid;
            Fluid fluid2;
            if (fluid instanceof FlowingFluid) {
                FlowingFluid flowingFluid = (FlowingFluid)fluid;
                fluid2 = flowingFluid.getSource();
            } else {
                fluid2 = fluid;
            }
            if (!uniqueFluids.add(processedFluid = fluid2) || (fullItem = processedFluid.getBucket()) == Items.AIR) continue;
            ItemStack fullItemStack = fullItem.getDefaultInstance();
            ItemStack emptyItemStack = fullItemStack.getCraftingRemainingItem();
            Item emptyItem = emptyItemStack.isEmpty() ? Items.BUCKET : emptyItemStack.getItem();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)fullItem);
            FluidStack fluidStack = new FluidStack(processedFluid, 1000);
            recipes.add(this.generateFillingBucket(fluidStack, itemId, fullItem, emptyItem));
            recipes.add(this.generateEmptyingBucket(fluidStack, itemId, fullItem, emptyItem));
        }
        return recipes;
    }

    protected void fillRecipeList(Level level) {
        this.recipeList.addAll(this.getManagerRecipes(level));
        this.recipeList.addAll(this.buildCannedFood());
        this.recipeList.addAll(this.buildBucket());
    }
}

