/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.guicomponent.universaltransformer;

import aztech.modern_industrialization.inventory.BackgroundRenderedSlot;
import aztech.modern_industrialization.inventory.SlotGroup;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.util.Rectangle;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.machines.component.TransformerTierComponent;
import net.swedz.extended_industrialization.machines.guicomponent.universaltransformer.UniversalTransformerSlots;

public final class UniversalTransformerSlotsClient
implements GuiComponentClient {
    public UniversalTransformerSlotsClient(RegistryFriendlyByteBuf buf) {
    }

    public void readCurrentData(RegistryFriendlyByteBuf buf) {
    }

    public void setupMenu(GuiComponent.MenuFacade menu) {
        class ClientSlot
        extends SlotWithBackground
        implements SlotTooltip {
            private final EIText tooltip;

            public ClientSlot(UniversalTransformerSlotsClient this$0, EIText tooltip, int index) {
                super((Container)new SimpleContainer(1), 0, UniversalTransformerSlots.getSlotX(), UniversalTransformerSlots.getSlotY(index));
                this.tooltip = tooltip;
            }

            public boolean mayPlace(ItemStack itemStack) {
                return TransformerTierComponent.getTierFromCasing(itemStack) != null;
            }

            public int getMaxStackSize() {
                return 1;
            }

            public int getBackgroundU() {
                return 18;
            }

            public int getBackgroundV() {
                return 80;
            }

            @Override
            public Component getTooltip() {
                return this.tooltip.text().withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xA9A9A9)));
            }
        }
        menu.addSlotToMenu((Slot)new ClientSlot(this, EIText.UNIVERSAL_TRANSFORMER_FROM_TIER_INPUT, 0), SlotGroup.CONFIGURABLE_STACKS);
        menu.addSlotToMenu((Slot)new ClientSlot(this, EIText.UNIVERSAL_TRANSFORMER_TO_TIER_INPUT, 1), SlotGroup.CONFIGURABLE_STACKS);
    }

    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new ClientComponentRenderer(this){
            private final ResourceLocation TRANSFORMER_DIRECTION = EI.id("textures/gui/container/universal_transformer_direction.png");

            private Rectangle getBox(int leftPos, int topPos) {
                return new Rectangle(leftPos - 31, topPos + 10, 31, 70);
            }

            public void addExtraBoxes(List<Rectangle> rectangles, int leftPos, int topPos) {
                rectangles.add(this.getBox(leftPos, topPos));
            }

            public void renderBackground(GuiGraphics graphics, int leftPos, int topPos) {
                Rectangle box = this.getBox(leftPos, topPos);
                int textureX = leftPos - box.x() - box.w();
                graphics.blit(MachineScreen.BACKGROUND, box.x(), box.y(), textureX, 0, box.w(), box.h() - 4);
                graphics.blit(MachineScreen.BACKGROUND, box.x(), box.y() + box.h() - 4, textureX, 252, box.w(), 4);
                graphics.blit(this.TRANSFORMER_DIRECTION, leftPos - 22, topPos + 37, 0.0f, 0.0f, 16, 16, 16, 16);
            }

            public void renderTooltip(MachineScreen screen, Font font, GuiGraphics graphics, int x, int y, int cursorX, int cursorY) {
                Slot slot = screen.getFocusedSlot();
                if (slot instanceof SlotTooltip) {
                    SlotTooltip st = (SlotTooltip)slot;
                    if (!screen.getFocusedSlot().hasItem()) {
                        graphics.renderTooltip(font, st.getTooltip(), cursorX, cursorY);
                    }
                }
            }
        };
    }

    private static class SlotWithBackground
    extends Slot
    implements BackgroundRenderedSlot {
        public SlotWithBackground(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }
    }

    static interface SlotTooltip {
        public Component getTooltip();
    }
}

