/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer.task.task;

import aztech.modern_industrialization.inventory.MIItemStorage;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.machines.component.farmer.FarmerComponent;
import net.swedz.extended_industrialization.machines.component.farmer.block.FarmerBlock;
import net.swedz.extended_industrialization.machines.component.farmer.block.FarmerTile;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.HarvestableBehavior;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.HarvestableBehaviorHolder;
import net.swedz.extended_industrialization.machines.component.farmer.harvesting.HarvestingContext;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTaskType;

public final class HarvestingFarmerTask
extends FarmerTask {
    private final HarvestableBehaviorHolder harvestingHandlers;
    private final Map<BlockPos, List<ItemStack>> cachedDrops = Maps.newHashMap();

    public HarvestingFarmerTask(FarmerComponent component) {
        super(FarmerTaskType.HARVESTING, component);
        this.harvestingHandlers = component.getHarvestableBehaviorHolder();
    }

    private boolean insertDrops(List<ItemStack> drops, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            MIItemStorage itemOutput = new MIItemStorage(this.inventory.getItemOutputs());
            boolean success = true;
            for (ItemStack item : drops) {
                long inserted = itemOutput.insertAllSlot((TransferVariant)ItemVariant.of((ItemStack)item), (long)item.getCount(), (TransactionContext)transaction);
                if (inserted == (long)item.getCount() || item.is(EITags.Items.FARMER_VOIDABLE)) continue;
                success = false;
                break;
            }
            if (!simulate) {
                transaction.commit();
            }
            boolean bl = success;
            return bl;
        }
    }

    private List<ItemStack> sortDrops(List<ItemStack> drops) {
        drops.sort(Comparator.comparing(item -> item.is(EITags.Items.FARMER_VOIDABLE)));
        return drops;
    }

    private List<ItemStack> getDrops(HarvestingContext context, HarvestableBehavior handler) {
        BlockPos origin = context.pos();
        if (this.cachedDrops.containsKey(origin)) {
            List<ItemStack> drops = List.copyOf((Collection)this.cachedDrops.get(origin));
            if (!this.insertDrops(drops, true)) {
                return List.of();
            }
            this.cachedDrops.remove(origin);
            return this.sortDrops(handler.getDrops(context));
        }
        List<ItemStack> drops = this.sortDrops(handler.getDrops(context));
        if (drops.isEmpty()) {
            return drops;
        }
        if (!this.insertDrops(drops, true)) {
            this.cachedDrops.put(origin, drops);
            return List.of();
        }
        return drops;
    }

    private boolean harvestBlocks(FarmerBlock cropBlockEntry, HarvestingContext context, HarvestableBehavior handler) {
        BlockPos origin = context.pos();
        List<BlockPos> blockPositions = handler.getBlocks(context);
        if (blockPositions.isEmpty()) {
            return false;
        }
        List<ItemStack> drops = this.getDrops(context, handler);
        if (drops.isEmpty()) {
            return false;
        }
        this.insertDrops(drops, false);
        BlockState newState = Blocks.AIR.defaultBlockState();
        int i = 0;
        for (BlockPos blockPosition : blockPositions) {
            this.level.setBlock(blockPosition, newState, 3);
            this.level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, blockPosition, GameEvent.Context.of((BlockState)this.level.getBlockState(blockPosition)));
            ++i;
        }
        cropBlockEntry.updateState(newState);
        handler.harvested(context);
        return true;
    }

    @Override
    protected boolean run() {
        for (FarmerTile tile : this.blockMap) {
            HarvestableBehavior handler;
            BlockState state;
            FarmerBlock crop = tile.crop();
            BlockPos pos = crop.pos();
            HarvestingContext context = new HarvestingContext(this.level, pos, state = crop.state(this.level));
            Optional handlerOptional = this.harvestingHandlers.behavior(context);
            if (!handlerOptional.isPresent() || !(handler = (HarvestableBehavior)handlerOptional.get()).isFullyGrown(context) || !this.harvestBlocks(crop, context, handler) || !this.operations.operate()) continue;
            return true;
        }
        return this.operations.didOperate();
    }
}

