/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.craft.processingarray;

import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.DropableComponent;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.guicomponent.processingarraymachineslot.ProcessingArrayMachineSlot;

public final class ProcessingArrayMachineComponent
implements IComponent.ServerOnly,
DropableComponent {
    public static final ResourceLocation ID = EI.id("processing_array_machine");
    private ItemStack machines = ItemStack.EMPTY;
    private MachineRecipeType machineRecipeType;

    public ItemStack getMachines() {
        return this.machines;
    }

    public boolean hasMachines() {
        return !this.machines.isEmpty() && this.machineRecipeType != null;
    }

    public int getMachineCount() {
        return this.machines.getCount();
    }

    public MachineRecipeType getMachineRecipeType() {
        return this.machineRecipeType;
    }

    public void setMachines(MachineBlockEntity be, ItemStack machines) {
        this.machines = machines;
        this.machineRecipeType = machines.isEmpty() ? null : ProcessingArrayMachineSlot.getMachine(machines).recipeType();
        be.setChanged();
        be.sync();
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("machinesStack", this.machines.saveOptional(registries));
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.machines = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("machinesStack"));
        if (!this.machines.isEmpty()) {
            this.machineRecipeType = ProcessingArrayMachineSlot.getMachine(this.machines).recipeType();
        }
    }

    public ItemStack getDrop() {
        return this.machines;
    }
}

