/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.chainer.handler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerLinks;
import net.swedz.extended_industrialization.machines.component.chainer.handler.SlotChainerHandler;
import net.swedz.extended_industrialization.machines.component.chainer.wrapper.SlotInventoryWrapper;

public final class ChainerFluidHandler
extends SlotChainerHandler<IFluidHandler>
implements IFluidHandler {
    public ChainerFluidHandler(ChainerLinks chainerLinks) {
        super(chainerLinks);
    }

    @Override
    public void invalidate() {
        ArrayList wrappers = Lists.newArrayList();
        int slots = 0;
        for (IFluidHandler handler : this.getMachineLinks().fluidHandlers()) {
            int handlerSlots = handler.getTanks();
            wrappers.add(new SlotInventoryWrapper<IFluidHandler>(handler, slots, handlerSlots));
            slots += handlerSlots;
        }
        this.wrappers = Collections.unmodifiableList(wrappers);
        this.slots = slots;
    }

    public int getTanks() {
        return this.slots;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getWrapper(tank).map(wrapper -> ((IFluidHandler)wrapper.handler()).getFluidInTank(wrapper.toLocalSlot(tank))).orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity(int tank) {
        return this.getWrapper(tank).map(wrapper -> ((IFluidHandler)wrapper.handler()).getTankCapacity(wrapper.toLocalSlot(tank))).orElse(0);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.getWrapper(tank).map(wrapper -> ((IFluidHandler)wrapper.handler()).isFluidValid(wrapper.toLocalSlot(tank), stack)).orElse(false);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.chainerLinks.doesAllowOperation()) {
            return 0;
        }
        int amountFilled = 0;
        for (int index = 0; index < this.wrappers.size(); ++index) {
            SlotInventoryWrapper wrapper = (SlotInventoryWrapper)this.wrappers.get(index);
            int remainingStorages = this.wrappers.size() - index;
            int remainingAmountToInsert = resource.getAmount() - amountFilled;
            int amountToInsert = remainingAmountToInsert / remainingStorages;
            amountFilled += ((IFluidHandler)wrapper.handler()).fill(resource.copyWithAmount(amountToInsert), action);
        }
        return amountFilled;
    }

    private FluidStack drain(Fluid fluid, int maxAmount, IFluidHandler.FluidAction action) {
        if (!this.chainerLinks.doesAllowOperation()) {
            return FluidStack.EMPTY;
        }
        int amountTransferred = 0;
        for (int index = 0; index < this.wrappers.size(); ++index) {
            FluidStack transferred;
            SlotInventoryWrapper wrapper = (SlotInventoryWrapper)this.wrappers.get(index);
            int remainingStorages = this.wrappers.size() - index;
            int remainingAmountToTransfer = maxAmount - amountTransferred;
            int amountToTansfer = remainingAmountToTransfer / remainingStorages;
            FluidStack fluidStack = transferred = fluid == null ? ((IFluidHandler)wrapper.handler()).drain(amountToTansfer, action) : ((IFluidHandler)wrapper.handler()).drain(new FluidStack(fluid, amountToTansfer), action);
            if (transferred.isEmpty()) continue;
            fluid = transferred.getFluid();
            amountTransferred += transferred.getAmount();
        }
        return fluid == null ? FluidStack.EMPTY : new FluidStack(fluid, amountTransferred);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.drain(resource.getFluid(), resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(null, maxDrain, action);
    }
}

