/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.chainer.handler;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerLinks;
import net.swedz.extended_industrialization.machines.component.chainer.handler.ChainerHandler;
import net.swedz.extended_industrialization.machines.component.chainer.wrapper.InventoryWrapper;

public final class ChainerEnergyHandler
extends ChainerHandler<MIEnergyStorage, InventoryWrapper<MIEnergyStorage>>
implements MIEnergyStorage {
    private final boolean insertable;

    public ChainerEnergyHandler(ChainerLinks chainerLinks, boolean insertable) {
        super(chainerLinks);
        this.insertable = insertable;
    }

    @Override
    public void invalidate() {
        ArrayList wrappers = Lists.newArrayList();
        for (MIEnergyStorage handler : this.getMachineLinks().energyHandlers()) {
            wrappers.add(new InventoryWrapper<MIEnergyStorage>(handler));
        }
        this.wrappers = Collections.unmodifiableList(wrappers);
    }

    public long receive(long maxReceive, boolean simulate) {
        if (!this.chainerLinks.doesAllowOperation() || !this.insertable) {
            return 0L;
        }
        long amountReceived = 0L;
        for (int i = 0; i < this.wrappers.size(); ++i) {
            InventoryWrapper wrapper = (InventoryWrapper)this.wrappers.get(i);
            int remainingStorages = this.wrappers.size() - i;
            long remainingAmountToReceive = maxReceive - amountReceived;
            long amountToReceive = remainingAmountToReceive / (long)remainingStorages;
            amountReceived += ((MIEnergyStorage)wrapper.handler()).receive(amountToReceive, simulate);
        }
        return amountReceived;
    }

    public long extract(long maxExtract, boolean simulate) {
        if (!this.chainerLinks.doesAllowOperation() || this.insertable) {
            return 0L;
        }
        long amountExtracted = 0L;
        for (InventoryWrapper wrapper : this.wrappers) {
            long remainingAmountToExtract = maxExtract - amountExtracted;
            if ((amountExtracted += ((MIEnergyStorage)wrapper.handler()).extract(remainingAmountToExtract, simulate)) != maxExtract) continue;
            break;
        }
        return amountExtracted;
    }

    public long getAmount() {
        return this.wrappers.stream().mapToLong(w -> ((MIEnergyStorage)w.handler()).getAmount()).sum();
    }

    public long getCapacity() {
        return this.wrappers.stream().mapToLong(w -> ((MIEnergyStorage)w.handler()).getCapacity()).sum();
    }

    public boolean canExtract() {
        return !this.insertable;
    }

    public boolean canReceive() {
        return this.insertable;
    }

    public boolean canConnect(CableTier cableTier) {
        return true;
    }
}

