/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.chainer;

import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.swedz.extended_industrialization.machines.blockentity.MachineChainerMachineBlockEntity;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerElement;
import net.swedz.extended_industrialization.machines.component.chainer.link.ChainerLinkable;
import net.swedz.extended_industrialization.machines.component.chainer.link.LinkContext;
import net.swedz.extended_industrialization.machines.component.chainer.link.LinkResult;
import net.swedz.extended_industrialization.machines.component.chainer.link.LinkableBehaviorHolder;
import net.swedz.extended_industrialization.machines.component.chainer.link.linkable.ChainerRelayLinkable;
import net.swedz.extended_industrialization.machines.component.chainer.link.linkable.MachineBlockLinkable;
import net.swedz.extended_industrialization.machines.component.chainer.link.linkable.TaggedLinkable;
import net.swedz.tesseract.neoforge.behavior.BehaviorRegistry;

public final class ChainerLinks
implements ChainerElement {
    private static final BehaviorRegistry<LinkableBehaviorHolder, ChainerLinkable, LinkContext> BEHAVIOR_REGISTRY = BehaviorRegistry.create(LinkableBehaviorHolder::new);
    private final Supplier<Level> level;
    private final BlockPos origin;
    private final Supplier<Direction> direction;
    private final int maxConnections;
    private final Supplier<Boolean> allowOperation;
    private final LinkableBehaviorHolder behaviorHolder;
    private List<BlockPos> positions = List.of();
    private int linkCount;
    private List<IItemHandler> itemHandlers = List.of();
    private List<IFluidHandler> fluidHandlers = List.of();
    private List<MIEnergyStorage> energyHandlers = List.of();
    private Optional<BlockPos> failPosition = Optional.empty();

    public static void registerLinkable(Supplier<ChainerLinkable> creator) {
        BEHAVIOR_REGISTRY.register(creator);
    }

    public ChainerLinks(MachineChainerMachineBlockEntity machine, int maxConnections, Supplier<Boolean> allowOperation) {
        this.level = () -> ((MachineChainerMachineBlockEntity)machine).getLevel();
        this.origin = machine.getBlockPos();
        this.direction = () -> machine.orientation.facingDirection;
        this.maxConnections = maxConnections;
        this.allowOperation = allowOperation;
        this.behaviorHolder = (LinkableBehaviorHolder)BEHAVIOR_REGISTRY.createHolder();
    }

    public Level level() {
        return this.level.get();
    }

    public BlockPos origin() {
        return this.origin;
    }

    public Direction direction() {
        return this.direction.get();
    }

    public List<BlockPos> positions() {
        return this.positions;
    }

    public BlockPos position(int offset) {
        return this.origin.relative(this.direction(), offset);
    }

    public BlockPos positionAfter() {
        return this.position(this.count() + 1);
    }

    public boolean isAfter(BlockPos pos) {
        return pos.equals((Object)this.positionAfter());
    }

    public int count() {
        return this.linkCount;
    }

    public boolean hasConnections() {
        return this.count() > 0;
    }

    void count(int count) {
        this.linkCount = count;
    }

    public boolean contains(BlockPos pos, boolean recursive) {
        if (this.positions.contains(pos)) {
            return true;
        }
        if (recursive) {
            for (BlockPos link : this.positions) {
                MachineChainerMachineBlockEntity chainerBlockEntity;
                BlockEntity blockEntity = this.level().getBlockEntity(link);
                if (!(blockEntity instanceof MachineChainerMachineBlockEntity) || !(chainerBlockEntity = (MachineChainerMachineBlockEntity)blockEntity).getChainerComponent().links().contains(pos, true)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(BlockPos pos) {
        return this.contains(pos, false);
    }

    public int maxConnections() {
        return this.maxConnections;
    }

    List<BlockPos> getSpannedBlocks(boolean includeOrigin, boolean includeFailure) {
        ArrayList blocks = Lists.newArrayList();
        if (includeOrigin) {
            blocks.add(this.origin);
        }
        for (int i = 1; i <= this.maxConnections; ++i) {
            blocks.add(this.origin.relative(this.direction(), i));
        }
        if (includeFailure && this.hasFailure()) {
            blocks.add(this.failPosition().orElseThrow());
        }
        return Collections.unmodifiableList(blocks);
    }

    Set<ChunkPos> getSpannedChunks(boolean includeOrigin, boolean includeFailure) {
        HashSet chunks = Sets.newHashSet();
        for (BlockPos block : this.getSpannedBlocks(includeOrigin, includeFailure)) {
            chunks.add(new ChunkPos(block));
        }
        return Collections.unmodifiableSet(chunks);
    }

    public boolean doesAllowOperation() {
        return this.allowOperation.get();
    }

    public List<IItemHandler> itemHandlers() {
        return this.itemHandlers;
    }

    public List<IFluidHandler> fluidHandlers() {
        return this.fluidHandlers;
    }

    public List<MIEnergyStorage> energyHandlers() {
        return this.energyHandlers;
    }

    public Optional<BlockPos> failPosition() {
        return this.failPosition;
    }

    public boolean hasFailure() {
        return this.failPosition.isPresent();
    }

    public int failPositionOffset() {
        return this.failPosition.map(fail -> fail.distManhattan((Vec3i)this.origin)).orElseThrow();
    }

    public boolean isFailPosition(BlockPos pos) {
        return this.failPosition.map(fail -> fail.equals((Object)pos)).orElse(false);
    }

    void failPosition(BlockPos pos) {
        this.failPosition = Optional.ofNullable(pos);
    }

    @Override
    public void clear() {
        this.positions = List.of();
        this.linkCount = 0;
        this.itemHandlers = List.of();
        this.fluidHandlers = List.of();
        this.energyHandlers = List.of();
        this.failPosition = Optional.empty();
    }

    public LinkResult test(BlockPos pos) {
        return this.behaviorHolder.test(LinkContext.of(this, pos));
    }

    public LinkResult test(ItemStack stack) {
        return this.behaviorHolder.test(LinkContext.of(this, stack));
    }

    @Override
    public void invalidate() {
        ArrayList machinesFound = Lists.newArrayList();
        ArrayList itemHandlers = Lists.newArrayList();
        ArrayList fluidHandlers = Lists.newArrayList();
        ArrayList energyHandlers = Lists.newArrayList();
        LinkResult result = null;
        for (BlockPos pos : this.getSpannedBlocks(false, false)) {
            result = this.test(pos);
            if (result.isSuccess()) {
                machinesFound.add(pos);
                result.itemHandler().ifPresent(itemHandlers::add);
                result.fluidHandler().ifPresent(fluidHandlers::add);
                result.energyHandler().ifPresent(energyHandlers::add);
                continue;
            }
            if (!result.invalidatesEverything()) break;
            this.clear();
            this.failPosition = result.failPosition();
            return;
        }
        this.positions = Collections.unmodifiableList(machinesFound);
        this.linkCount = this.positions.size();
        this.itemHandlers = Collections.unmodifiableList(itemHandlers);
        this.fluidHandlers = Collections.unmodifiableList(fluidHandlers);
        this.energyHandlers = Collections.unmodifiableList(energyHandlers);
        this.failPosition = result == null ? Optional.empty() : result.failPosition();
    }

    static {
        ChainerLinks.registerLinkable(ChainerRelayLinkable::new);
        ChainerLinks.registerLinkable(MachineBlockLinkable::new);
        ChainerLinks.registerLinkable(TaggedLinkable::new);
    }
}

