/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.brewery;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.OverclockComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.GunpowderOverclockGui;
import aztech.modern_industrialization.machines.helper.SteamHelper;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.Fluid;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.machines.blockentity.brewery.BreweryMachineBlockEntity;

public final class SteamBreweryMachineBlockEntity
extends BreweryMachineBlockEntity {
    private final OverclockComponent overclockComponent = new OverclockComponent(OverclockComponent.getDefaultCatalysts());

    public SteamBreweryMachineBlockEntity(BEP bep, boolean bronze) {
        super(bep, (bronze ? "bronze" : "steel") + "_brewery", bronze ? MachineTier.BRONZE : MachineTier.STEEL, (bronze ? 8 : 16) * 1000);
        GunpowderOverclockGui.Parameters gunpowderOverclockGuiParams = new GunpowderOverclockGui.Parameters(97, 63);
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new GunpowderOverclockGui.Server(gunpowderOverclockGuiParams, () -> ((OverclockComponent)this.overclockComponent).getTicks());
        this.registerGuiComponent(serverArray);
        this.registerComponents(new IComponent[]{this.overclockComponent});
    }

    @Override
    protected MachineInventoryComponent buildInventory() {
        int i;
        ArrayList itemInputs = Lists.newArrayList();
        ArrayList itemOutputs = Lists.newArrayList();
        for (i = 0; i < 9; ++i) {
            itemInputs.add(ConfigurableItemStack.standardInputSlot());
        }
        for (i = 0; i < 9; ++i) {
            itemOutputs.add(ConfigurableItemStack.standardOutputSlot());
        }
        SlotPositions itemPositions = new SlotPositions.Builder().addSlots(43, 27, 3, 3).addSlots(119, 27, 3, 3).build();
        List<ConfigurableFluidStack> fluidInputs = Arrays.asList(ConfigurableFluidStack.lockedInputSlot((long)this.capacity, (Fluid)MIFluids.STEAM.asFluid()), ConfigurableFluidStack.lockedInputSlot((long)this.capacity, (Fluid)EIFluids.BLAZING_ESSENCE.asFluid()));
        SlotPositions fluidPositions = new SlotPositions.Builder().addSlot(5, 45).addSlot(24, 45).build();
        return new MachineInventoryComponent((List)itemInputs, (List)itemOutputs, fluidInputs, List.of(), itemPositions, fluidPositions);
    }

    public long consumeEu(long max, Simulation simulation) {
        return SteamHelper.consumeSteamEu((List)this.inventory.getFluidInputs(), (long)max, (Simulation)simulation);
    }

    @Override
    public long getMaxRecipeEu() {
        return this.overclockComponent.getRecipeEu(this.tier.getMaxEu());
    }

    @Override
    public long getBaseRecipeEu() {
        return this.overclockComponent.getRecipeEu(this.tier.getBaseEu());
    }

    @Override
    public List<Component> getTooltips() {
        ArrayList tooltips = Lists.newArrayList();
        tooltips.addAll(this.overclockComponent.getTooltips());
        tooltips.addAll(super.getTooltips());
        return tooltips;
    }

    @Override
    public void tick() {
        super.tick();
        this.overclockComponent.tick((MachineBlockEntity)this);
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            return this.overclockComponent.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }
}

