/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.brewery;

import aztech.modern_industrialization.api.machine.component.CrafterAccess;
import aztech.modern_industrialization.api.machine.holder.CrafterComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Tickable;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIMachines;
import net.swedz.extended_industrialization.EIText;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

public abstract class BreweryMachineBlockEntity
extends MachineBlockEntity
implements Tickable,
CrafterComponentHolder,
CrafterComponent.Behavior {
    protected static final int STEAM_SLOT_X = 5;
    protected static final int STEAM_SLOT_Y = 45;
    protected static final int BLAZING_ESSENCE_SLOT_X = 24;
    protected static final int BLAZING_ESSENCE_SLOT_Y = 45;
    protected static final int INPUT_SLOTS_X = 43;
    protected static final int INPUT_SLOTS_Y = 27;
    protected static final int OUTPUT_SLOTS_X = 119;
    protected static final int OUTPUT_SLOTS_Y = 27;
    protected static final int PROGRESS_BAR_X = 97;
    protected static final int PROGRESS_BAR_Y = 43;
    protected final MachineTier tier;
    protected final int capacity;
    protected final MachineInventoryComponent inventory;
    protected final CrafterComponent crafter;
    protected IsActiveComponent isActiveComponent;

    public BreweryMachineBlockEntity(BEP bep, String blockName, MachineTier tier, int capacity) {
        super(bep, new MachineGuiParameters.Builder(blockName, true).backgroundHeight(186).build(), new OrientationComponent.Params(true, true, false));
        this.tier = tier;
        this.capacity = capacity;
        this.inventory = this.buildInventory();
        this.crafter = new CrafterComponent((MachineBlockEntity)this, (CrafterComponent.Inventory)this.inventory, (CrafterComponent.Behavior)this);
        this.isActiveComponent = new IsActiveComponent();
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new ProgressBar.Server(new ProgressBar.Parameters(97, 43, "triple_arrow"), () -> ((CrafterComponent)this.crafter).getProgress());
        this.registerGuiComponent(serverArray);
        this.registerComponents(new IComponent[]{this.isActiveComponent, this.inventory, this.crafter});
        this.registerGuiComponent(new GuiComponent.Server[]{new AutoExtract.Server(this.orientation)});
    }

    protected abstract MachineInventoryComponent buildInventory();

    public MIInventory getInventory() {
        return this.inventory.inventory;
    }

    public CrafterAccess getCrafterComponent() {
        return this.crafter;
    }

    public MachineRecipeType recipeType() {
        return EIMachines.RecipeTypes.BREWERY;
    }

    public Level getCrafterWorld() {
        return this.level;
    }

    public UUID getOwnerUuid() {
        return this.placedBy.placerId;
    }

    public long getBaseRecipeEu() {
        return this.tier.getBaseEu();
    }

    public long getMaxRecipeEu() {
        return this.tier.getMaxEu();
    }

    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        this.updateActive(this.crafter.tickRecipe());
        if (this.orientation.extractItems) {
            this.getInventory().autoExtractItems(this.level, this.worldPosition, this.orientation.outputDirection);
        }
        this.setChanged();
    }

    private void updateActive(boolean active) {
        this.isActiveComponent.updateActive(active, (MachineBlockEntity)this);
    }

    public List<Component> getTooltips() {
        return List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.BREWERY_REQUIRES_BLAZING_ESSENCE).arg((Object)EIFluids.BLAZING_ESSENCE.asFluid()), MICompatibleTextLine.line((TranslatableTextEnum)EIText.BREWERY_BREWS_MULTIPLE).arg((Object)4));
    }
}

