/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import java.util.function.BiPredicate;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.swedz.extended_industrialization.machines.component.WirelessChargingComponent;

public final class WirelessChargerMachineBlockEntity
extends MachineBlockEntity
implements EnergyComponentHolder,
Tickable {
    private final RedstoneControlComponent redstoneControl = new RedstoneControlComponent();
    private final EnergyComponent energy = new EnergyComponent((BlockEntity)this, () -> tier.eu * 100L);
    private final MIEnergyStorage insertable = this.energy.buildInsertable(otherTier -> otherTier == tier);
    private final WirelessChargingComponent wirelessCharging;

    public WirelessChargerMachineBlockEntity(BEP bep, ResourceLocation blockId, CableTier tier, BiPredicate<MachineBlockEntity, Player> filter) {
        super(bep, new MachineGuiParameters.Builder(blockId, false).build(), new OrientationComponent.Params(false, false, false));
        this.wirelessCharging = new WirelessChargingComponent(this, this.energy, filter, () -> tier.eu * 8L);
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new EnergyBar.Server(new EnergyBar.Parameters(76, 39), () -> ((EnergyComponent)this.energy).getEu(), () -> ((EnergyComponent)this.energy).getCapacity());
        this.registerGuiComponent(serverArray);
        this.registerGuiComponent(new GuiComponent.Server[]{new SlotPanel.Server((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl)});
        this.registerComponents(new IComponent[]{this.energy, this.redstoneControl, this.wirelessCharging});
    }

    public EnergyAccess getEnergyComponent() {
        return this.energy;
    }

    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        this.orientation.writeModelData(data);
        return data;
    }

    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        if (this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this)) {
            this.wirelessCharging.tick();
        }
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> ((WirelessChargerMachineBlockEntity)be).insertable));
    }
}

