/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.util.Simulation;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.component.TransformerTierComponent;
import net.swedz.extended_industrialization.machines.guicomponent.universaltransformer.UniversalTransformerSlots;

public final class UniversalTransformerMachineBlockEntity
extends MachineBlockEntity
implements EnergyComponentHolder {
    private final RedstoneControlComponent redstoneControl;
    private final EnergyComponent energy;
    private final MIEnergyStorage insertable;
    private final MIEnergyStorage extractable;
    private final TransformerTierComponent transformerFrom = new TransformerTierComponent(true);
    private final TransformerTierComponent transformerTo = new TransformerTierComponent(false);

    public UniversalTransformerMachineBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder(EI.id("universal_transformer"), false).build(), new OrientationComponent.Params(true, false, false));
        this.redstoneControl = new RedstoneControlComponent();
        this.energy = new EnergyComponent((BlockEntity)this, () -> 200L * Math.min(this.transformerFrom.getTier().getEu(), this.transformerTo.getTier().getEu()));
        this.insertable = this.energy.buildInsertable(this.transformerFrom::canInsertEu);
        this.extractable = this.energy.buildExtractable(tier -> this.transformerTo.canInsertEu((CableTier)tier) && this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this));
        this.registerComponents(new IComponent[]{this.transformerFrom, this.transformerTo, this.energy, this.redstoneControl});
        EnergyBar.Parameters energyBarParams = new EnergyBar.Parameters(76, 39);
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new EnergyBar.Server(energyBarParams, () -> ((EnergyComponent)this.energy).getEu(), () -> ((EnergyComponent)this.energy).getCapacity());
        this.registerGuiComponent(serverArray);
        this.registerGuiComponent(new GuiComponent.Server[]{new SlotPanel.Server((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl)});
        this.registerGuiComponent(new GuiComponent.Server[]{new UniversalTransformerSlots.Server(this, this.transformerFrom, this.transformerTo)});
    }

    public EnergyAccess getEnergyComponent() {
        return this.energy;
    }

    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        this.orientation.writeModelData(data);
        return data;
    }

    private boolean isExtractableOnOutputDirection() {
        return this.transformerFrom.getTier().getEu() < this.transformerTo.getTier().getEu();
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ILongEnergyStorage energyItem = (ILongEnergyStorage)player.getItemInHand(hand).getCapability(EnergyApi.ITEM);
        int stackSize = player.getItemInHand(hand).getCount();
        if (energyItem != null) {
            if (!player.level().isClientSide()) {
                Transaction transaction;
                int i;
                boolean insertedSomething = false;
                for (i = 0; i < 10000; ++i) {
                    transaction = Transaction.openOuter();
                    try {
                        long inserted = energyItem.receive(this.energy.getEu() / (long)stackSize, false);
                        if (inserted == 0L) break;
                        insertedSomething = true;
                        this.energy.consumeEu(inserted * (long)stackSize, Simulation.ACT);
                        transaction.commit();
                        continue;
                    }
                    finally {
                        if (transaction != null) {
                            transaction.close();
                        }
                    }
                }
                if (!insertedSomething) {
                    for (i = 0; i < 10000; ++i) {
                        transaction = Transaction.openOuter();
                        try {
                            long extracted = energyItem.extract(this.energy.getRemainingCapacity() / (long)stackSize, false);
                            if (extracted == 0L) break;
                            this.energy.insertEu(extracted * (long)stackSize, Simulation.ACT);
                            transaction.commit();
                            continue;
                        }
                        finally {
                            if (transaction != null) {
                                transaction.close();
                            }
                        }
                    }
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)player.level().isClientSide());
        }
        return super.useItemOn(player, hand, face);
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> {
            UniversalTransformerMachineBlockEntity machine = (UniversalTransformerMachineBlockEntity)((Object)((Object)be));
            if (machine.isExtractableOnOutputDirection()) {
                return machine.orientation.outputDirection == direction ? machine.extractable : machine.insertable;
            }
            return machine.orientation.outputDirection == direction ? machine.insertable : machine.extractable;
        }));
    }
}

