/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIConfig;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerComponent;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerLinks;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock.ModularMultiblockGui;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock.ModularMultiblockGuiLine;
import net.swedz.tesseract.neoforge.compat.mi.helper.transfer.MIEnergyTransferCache;
import net.swedz.tesseract.neoforge.helper.transfer.FluidTransferCache;
import net.swedz.tesseract.neoforge.helper.transfer.ItemTransferCache;

public final class MachineChainerMachineBlockEntity
extends MachineBlockEntity
implements Tickable {
    private final RedstoneControlComponent redstoneControl = new RedstoneControlComponent();
    private final ChainerComponent chainer = new ChainerComponent(this, EIConfig.machineChainerMaxConnections, () -> this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this));
    private final ItemTransferCache transferItem = new ItemTransferCache(this.chainer::itemHandler);
    private final FluidTransferCache transferFluid = new FluidTransferCache(this.chainer::fluidHandler);
    private final MIEnergyTransferCache transferEnergy = new MIEnergyTransferCache(this.chainer::extractableEnergyHandler);
    private int tick;
    private int lastRebuildTick = -1;
    private boolean needsRebuild;

    public MachineChainerMachineBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder(EI.id("machine_chainer"), false).backgroundHeight(175).build(), new OrientationComponent.Params(true, true, true));
        this.registerGuiComponent(new GuiComponent.Server[]{new SlotPanel.Server((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl)});
        this.registerGuiComponent(new GuiComponent.Server[]{new AutoExtract.Server(this.orientation)});
        this.registerGuiComponent(new GuiComponent.Server[]{new ModularMultiblockGui.Server(11, 50, () -> {
            ChainerLinks links = this.chainer.links();
            ArrayList text = Lists.newArrayList();
            if (!links.hasConnections() && links.failPosition().isPresent()) {
                text.add(new ModularMultiblockGuiLine((Component)EIText.MACHINE_CHAINER_PROBLEM_AT.text(new Object[]{links.failPosition().get().toShortString()}), 0xFF0000));
            } else {
                text.add(new ModularMultiblockGuiLine((Component)EIText.MACHINE_CHAINER_CONNECTED_MACHINES.text(new Object[]{links.count(), links.maxConnections()})));
            }
            return text;
        })});
        this.registerComponents(new IComponent[]{this.chainer, this.redstoneControl});
    }

    public ChainerComponent getChainerComponent() {
        return this.chainer;
    }

    public void buildLinks() {
        if (this.tick == this.lastRebuildTick) {
            EI.LOGGER.warn("Prevented Machine Chainer in dimension '{}' at ({}) from rebuilding links more than once in the same tick!", (Object)this.level.dimension().location(), (Object)this.worldPosition.toShortString());
            return;
        }
        this.needsRebuild = false;
        if (!this.level.isClientSide()) {
            this.chainer.unregisterListeners();
            this.chainer.invalidate();
            this.chainer.registerListeners();
        }
        this.invalidateCapabilities();
        this.setChanged();
        if (!this.level.isClientSide()) {
            this.sync();
        }
        this.lastRebuildTick = this.tick;
    }

    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        this.orientation.writeModelData(data);
        return data;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (!level.isClientSide()) {
            this.needsRebuild = true;
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.level.isClientSide()) {
            this.chainer.unregisterListeners();
            this.chainer.clear();
        }
    }

    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        if (++this.tick % 200 == 0) {
            this.needsRebuild = true;
        }
        if (this.needsRebuild) {
            this.buildLinks();
        }
        if (this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this)) {
            if (this.orientation.extractItems) {
                this.transferItem.autoExtract(this.level, this.worldPosition, this.orientation.outputDirection);
            }
            if (this.orientation.extractFluids) {
                this.transferFluid.autoExtract(this.level, this.worldPosition, this.orientation.outputDirection);
            }
            if (this.transferEnergy.autoExtract(this.level, this.worldPosition, this.orientation.outputDirection)) {
                this.setChanged();
            }
        }
    }

    public static void registerCapabilities(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, bet, (be, direction) -> ((MachineChainerMachineBlockEntity)((Object)((Object)be))).getChainerComponent().itemHandler());
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, bet, (be, direction) -> ((MachineChainerMachineBlockEntity)((Object)((Object)be))).getChainerComponent().fluidHandler());
            event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> {
                MachineChainerMachineBlockEntity machine = (MachineChainerMachineBlockEntity)((Object)((Object)be));
                ChainerComponent chainer = machine.getChainerComponent();
                return machine.orientation.outputDirection == direction ? chainer.extractableEnergyHandler() : chainer.insertableEnergyHandler();
            });
        });
    }
}

