/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item.nanosuit;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.EITooltips;
import net.swedz.extended_industrialization.item.nanosuit.NanoSuitAbility;
import net.swedz.extended_industrialization.item.nanosuit.NanoSuitArmorItem;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

public final class NanoSuitSpeedAbility
implements NanoSuitAbility {
    private static final long ENERGY_COST = 2L;
    private static final double SPEED_BOOST = 0.4;

    @Override
    public ArmorItem.Type armorType() {
        return ArmorItem.Type.LEGGINGS;
    }

    @Override
    public ItemAttributeModifiers getModifiedDefaultAttributeModifiers(NanoSuitArmorItem item, ItemStack stack, ItemAttributeModifiers modifiers) {
        if (item.getStoredEnergy(stack) > 0L && item.isActivated(stack)) {
            modifiers = modifiers.withModifierAdded(Attributes.MOVEMENT_SPEED, new AttributeModifier(EI.id("nano_speed_boost"), 0.4, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), this.equipmentSlotGroup());
        }
        return modifiers;
    }

    @Override
    public Optional<List<Component>> getTooltipLines(NanoSuitArmorItem item, ItemStack stack) {
        return Optional.of(List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.NANO_SUIT_SPEED).arg((Object)item.isActivated(stack), EITooltips.ACTIVATED_BOOLEAN_PARSER)));
    }

    @Override
    public List<Component> getHelpTooltipLines(NanoSuitArmorItem item, ItemStack stack) {
        return List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.NANO_SUIT_HELP_SPEED).arg((Object)"%s.toggle_leggings_ability".formatted("extended_industrialization"), EITooltips.KEYBIND_PARSER));
    }

    @Override
    public void onActivationChange(NanoSuitArmorItem item, Player player, ItemStack stack, boolean activated) {
        player.displayClientMessage((Component)(activated ? EIText.NANO_SUIT_SPEED_TOGGLED_ON : EIText.NANO_SUIT_SPEED_TOGGLED_OFF).text(), true);
    }

    @Override
    public void tick(NanoSuitArmorItem item, LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
        if (item.getStoredEnergy(stack) > 0L && item.isActivated(stack)) {
            item.tryUseEnergy(stack, 2L);
        }
    }
}

