/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item.machineconfig;

import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;

public interface MachineConfigSlot<T, S extends AbstractConfigurableStack> {
    public static final Codec<MachineConfigSlot> CODEC = Codec.either(ItemSlot.CODEC, FluidSlot.CODEC).xmap(either -> (MachineConfigSlot)either.map(Function.identity(), Function.identity()), slot -> {
        if (slot instanceof ItemSlot) {
            ItemSlot itemSlot = (ItemSlot)slot;
            return Either.left((Object)itemSlot);
        }
        if (slot instanceof FluidSlot) {
            FluidSlot fluidSlot = (FluidSlot)slot;
            return Either.right((Object)fluidSlot);
        }
        throw new IllegalArgumentException("Invalid machine config slot type provided");
    });

    public int index();

    public T lock();

    public S stack(MIInventory var1);

    public static final class ItemSlot
    extends Record
    implements MachineConfigSlot<Item, ConfigurableItemStack> {
        private final int index;
        private final int capacity;
        private final Item lock;
        private static final Codec<ItemSlot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("index").forGetter(ItemSlot::index), (App)Codec.INT.fieldOf("capacity").forGetter(ItemSlot::capacity), (App)BuiltInRegistries.ITEM.byNameCodec().optionalFieldOf("item_lock").forGetter(s -> Optional.ofNullable(s.lock()))).apply((Applicative)instance, (index, capacity, lock) -> new ItemSlot((int)index, (int)capacity, lock.orElse(null))));

        public ItemSlot(int index, int capacity, Item lock) {
            this.index = index;
            this.capacity = capacity;
            this.lock = lock;
        }

        @Override
        public ConfigurableItemStack stack(MIInventory inventory) {
            return (ConfigurableItemStack)inventory.getItemStacks().get(this.index);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemSlot.class, "index;capacity;lock", "index", "capacity", "lock"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemSlot.class, "index;capacity;lock", "index", "capacity", "lock"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemSlot.class, "index;capacity;lock", "index", "capacity", "lock"}, this, o);
        }

        @Override
        public int index() {
            return this.index;
        }

        public int capacity() {
            return this.capacity;
        }

        @Override
        public Item lock() {
            return this.lock;
        }
    }

    public static final class FluidSlot
    extends Record
    implements MachineConfigSlot<Fluid, ConfigurableFluidStack> {
        private final int index;
        private final Fluid lock;
        private static final Codec<FluidSlot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("index").forGetter(FluidSlot::index), (App)BuiltInRegistries.FLUID.byNameCodec().optionalFieldOf("fluid_lock").forGetter(s -> Optional.ofNullable(s.lock()))).apply((Applicative)instance, (index, lock) -> new FluidSlot((int)index, lock.orElse(null))));

        public FluidSlot(int index, Fluid lock) {
            this.index = index;
            this.lock = lock;
        }

        @Override
        public ConfigurableFluidStack stack(MIInventory inventory) {
            return (ConfigurableFluidStack)inventory.getFluidStacks().get(this.index);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FluidSlot.class, "index;lock", "index", "lock"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FluidSlot.class, "index;lock", "index", "lock"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FluidSlot.class, "index;lock", "index", "lock"}, this, o);
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public Fluid lock() {
            return this.lock;
        }
    }
}

