/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.items.ContainerItem;
import aztech.modern_industrialization.items.DynamicToolItem;
import aztech.modern_industrialization.items.ItemContainingItemHelper;
import aztech.modern_industrialization.items.ItemHelper;
import aztech.modern_industrialization.items.SteamDrillFuel;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.TextHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.apache.commons.lang3.mutable.Mutable;

public final class SteamChainsawItem
extends Item
implements DynamicToolItem,
ItemContainingItemHelper {
    public static final StorageBehaviour<ItemVariant> BEHAVIOR = new StorageBehaviour<ItemVariant>(){

        public long getCapacityForResource(ItemVariant resource) {
            return resource.getMaxStackSize();
        }

        public boolean canInsert(ItemVariant item) {
            return item.toStack().getBurnTime(null) > 0;
        }
    };
    private static final int FULL_WATER = 18000;

    public SteamChainsawItem(Item.Properties settings) {
        super(settings.stacksTo(1).rarity(Rarity.UNCOMMON));
    }

    private static boolean isNotSilkTouch(ItemStack stack) {
        return (Boolean)stack.getOrDefault(MIComponents.SILK_TOUCH, (Object)true) == false;
    }

    private static void setSilkTouch(ItemStack stack, boolean silkTouch) {
        stack.set(MIComponents.SILK_TOUCH, (Object)silkTouch);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !newStack.is((Item)this) || slotChanged;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !newStack.is((Item)this) || !this.canUse(newStack);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (this.isSupportedBlock(stack, state) && this.canUse(stack) && !state.is(Tiers.NETHERITE.getIncorrectBlocksForDrops())) {
            return true;
        }
        return super.isCorrectToolForDrops(stack, state);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.canUse(stack)) {
            if (this.isCorrectToolForDrops(stack, state)) {
                return Tiers.DIAMOND.getSpeed();
            }
            return 1.0f;
        }
        return 0.0f;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return this.canUse(stack) ? ItemHelper.getToolModifiers((double)7.0) : ItemAttributeModifiers.EMPTY;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miner) {
        this.useFuel(stack, miner);
        return true;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.useFuel(stack, attacker);
        return true;
    }

    public void useFuel(ItemStack stack, LivingEntity entity) {
        if ((Integer)stack.getOrDefault(MIComponents.WATER, (Object)0) > 0 && ((SteamDrillFuel)stack.getOrDefault(MIComponents.STEAM_DRILL_FUEL, (Object)SteamDrillFuel.EMPTY)).burnTicks() == 0) {
            int burnTicks = this.consumeFuel(stack, Simulation.ACT);
            stack.set(MIComponents.STEAM_DRILL_FUEL, (Object)new SteamDrillFuel(burnTicks, burnTicks));
            if (burnTicks > 0 && entity != null) {
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.FIRE_AMBIENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player user, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && user.isShiftKeyDown()) {
            ItemStack stack = user.getItemInHand(hand);
            SteamChainsawItem.setSilkTouch(stack, SteamChainsawItem.isNotSilkTouch(stack));
            if (!level.isClientSide) {
                user.displayClientMessage((Component)(SteamChainsawItem.isNotSilkTouch(stack) ? MIText.ToolSwitchedNoSilkTouch.text() : MIText.ToolSwitchedSilkTouch.text()), true);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        ItemStack itemStack = user.getItemInHand(hand);
        BlockHitResult hitResult = SteamChainsawItem.getPlayerPOVHitResult((Level)level, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        FluidState fluidState = level.getFluidState(hitResult.getBlockPos());
        if (fluidState.getType() == Fluids.WATER || fluidState.getType() == Fluids.FLOWING_WATER) {
            this.fillWater(user, itemStack);
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
        }
        return super.use(level, user, hand);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        Level level = interactionTarget.level();
        BlockPos blockPos = interactionTarget.blockPosition();
        if (this.canUse(stack) && stack.is(Tags.Items.TOOLS_SHEAR) && interactionTarget instanceof IShearable) {
            IShearable shearable = (IShearable)interactionTarget;
            if (!level.isClientSide && shearable.isShearable(player, stack, level, blockPos)) {
                this.useFuel(stack, (LivingEntity)player);
                shearable.onSheared(player, stack, level, blockPos).forEach(drop -> shearable.spawnShearedDrop(level, blockPos, drop));
                interactionTarget.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private void fillWater(Player player, ItemStack stack) {
        if ((Integer)stack.getOrDefault(MIComponents.WATER, (Object)0) != 18000) {
            stack.set(MIComponents.WATER, (Object)18000);
            player.playNotifySound(SoundEvents.BUCKET_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        SteamDrillFuel fuel = (SteamDrillFuel)stack.getOrDefault(MIComponents.STEAM_DRILL_FUEL, (Object)SteamDrillFuel.EMPTY);
        if (fuel.burnTicks() > 0) {
            stack.set(MIComponents.STEAM_DRILL_FUEL, (Object)new SteamDrillFuel(Math.max(0, fuel.burnTicks() - 5), fuel.maxBurnTicks()));
            int water = (Integer)stack.get(MIComponents.WATER);
            if (water > 0) {
                stack.set(MIComponents.WATER, (Object)water);
            } else {
                stack.remove(MIComponents.WATER);
            }
        }
        if (fuel.burnTicks() == 0) {
            stack.remove(MIComponents.STEAM_DRILL_FUEL);
        }
        if ((Integer)stack.getOrDefault(MIComponents.WATER, (Object)0) == 0 && entity instanceof Player) {
            Player player = (Player)entity;
            Inventory inv = player.getInventory();
            for (int i = 0; i < inv.getContainerSize() && !this.tryFillWater(player, stack, inv.getItem(i)); ++i) {
            }
        }
    }

    public boolean canUse(ItemStack stack) {
        if ((Integer)stack.getOrDefault(MIComponents.WATER, (Object)0) == 0) {
            return false;
        }
        return ((SteamDrillFuel)stack.getOrDefault(MIComponents.STEAM_DRILL_FUEL, (Object)SteamDrillFuel.EMPTY)).burnTicks() > 0 || this.consumeFuel(stack, Simulation.SIMULATE) > 0;
    }

    private int consumeFuel(ItemStack stack, Simulation simulation) {
        int burnTicks = ((ItemVariant)this.getResource(stack)).toStack().getBurnTime(null);
        if (burnTicks > 0) {
            if (simulation.isActing()) {
                ItemStack burnt = ((ItemVariant)this.getResource(stack)).toStack();
                this.setAmount(stack, this.getAmount(stack) - 1L);
                if (burnt.hasCraftingRemainingItem()) {
                    new ContainerItem.ItemHandler(stack, (ContainerItem)this).insertItem(0, burnt.getCraftingRemainingItem(), false, true, true);
                }
            }
            return burnTicks;
        }
        return 0;
    }

    public int getEnchantmentLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        return this.getAllEnchantments(stack, (HolderLookup.RegistryLookup<Enchantment>)enchantment.unwrapLookup()).getLevel(enchantment);
    }

    public ItemEnchantments getAllEnchantments(ItemStack stack, HolderLookup.RegistryLookup<Enchantment> lookup) {
        ItemEnchantments.Mutable map = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        if (!SteamChainsawItem.isNotSilkTouch(stack)) {
            lookup.get(Enchantments.SILK_TOUCH).ifPresent(enchantment -> map.set((Holder)enchantment, 1));
        }
        return map.toImmutable();
    }

    public boolean isFoil(ItemStack stack) {
        return !SteamChainsawItem.isNotSilkTouch(stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        Block newBlock;
        ItemStack stack = context.getItemInHand();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        if (this.canUse(stack) && stack.is(ItemTags.AXES) && (newBlock = StrippingAccess.getStrippedBlocks().get(state.getBlock())) != null) {
            level.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)newBlock.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS))), 11);
                this.useFuel(stack, (LivingEntity)player);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(context);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        SteamDrillFuel fuel = (SteamDrillFuel)stack.getOrDefault(MIComponents.STEAM_DRILL_FUEL, (Object)SteamDrillFuel.EMPTY);
        return Optional.of(new SteamChainsawTooltipData((Integer)stack.getOrDefault(MIComponents.WATER, (Object)0) * 100 / 18000, fuel.burnTicks(), Math.max(1, fuel.maxBurnTicks()), (ItemVariant)this.getResource(stack), this.getAmount(stack)));
    }

    public boolean overrideStackedOnOther(ItemStack stackBarrel, Slot slot, ClickAction clickType, Player player) {
        return this.handleStackedOnOther(stackBarrel, slot, clickType, player);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stackBarrel, ItemStack itemStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        return this.handleOtherStackedOnMe(stackBarrel, itemStack, slot, clickType, player, cursorStackReference);
    }

    public boolean handleClick(Player player, ItemStack barrelLike, Mutable<ItemStack> otherStack) {
        if (this.tryFillWater(player, barrelLike, (ItemStack)otherStack.getValue())) {
            return true;
        }
        return super.handleClick(player, barrelLike, otherStack);
    }

    private boolean tryFillWater(Player player, ItemStack barrelLike, ItemStack fillSource) {
        IFluidHandlerItem otherStorage = (IFluidHandlerItem)fillSource.getCapability(Capabilities.FluidHandler.ITEM);
        if (otherStorage != null) {
            long totalWater = 0L;
            for (int tank = 0; tank < otherStorage.getTanks(); ++tank) {
                if (otherStorage.getFluidInTank(tank).getFluid() != Fluids.WATER) continue;
                totalWater += (long)otherStorage.getFluidInTank(tank).getAmount();
            }
            if (totalWater * (long)fillSource.getCount() >= 1000L) {
                this.fillWater(player, barrelLike);
                return true;
            }
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        SteamChainsawTooltipData data = (SteamChainsawTooltipData)this.getTooltipImage(stack).orElseThrow();
        tooltip.add((Component)MIText.WaterPercent.text(new Object[]{data.waterLevel}).setStyle(TextHelper.WATER_TEXT));
        int barWater = (int)Math.ceil((double)data.waterLevel / 5.0);
        int barVoid = 20 - barWater;
        tooltip.add((Component)Component.literal((String)"|".repeat(barWater)).setStyle(TextHelper.WATER_TEXT).append((Component)Component.literal((String)"|".repeat(barVoid)).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x6B6B6B)))));
        if (data.burnTicks > 0) {
            tooltip.add((Component)MIText.SecondsLeft.text(new Object[]{data.burnTicks / 100}).setStyle(TextHelper.GRAY_TEXT));
        }
        if (context.registries() != null) {
            for (Object2IntMap.Entry entry : this.getAllEnchantments(stack, (HolderLookup.RegistryLookup<Enchantment>)context.registries().lookupOrThrow(Registries.ENCHANTMENT)).entrySet()) {
                tooltip.add(Enchantment.getFullname((Holder)((Holder)entry.getKey()), (int)entry.getIntValue()));
            }
        }
    }

    public StorageBehaviour<ItemVariant> getBehaviour() {
        return BEHAVIOR;
    }

    private static class StrippingAccess
    extends AxeItem {
        private StrippingAccess(Tier material, Item.Properties properties) {
            super(material, properties);
        }

        public static Map<Block, Block> getStrippedBlocks() {
            return AxeItem.STRIPPABLES;
        }
    }

    public record SteamChainsawTooltipData(int waterLevel, int burnTicks, int maxBurnTicks, ItemVariant variant, long amount) implements TooltipComponent
    {
    }
}

