/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item;

import aztech.modern_industrialization.api.energy.CableTier;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.swedz.extended_industrialization.EIComponents;

public final class PhotovoltaicCellItem
extends Item {
    private final CableTier tier;
    private final int euPerTick;
    private final int durationTicks;

    public PhotovoltaicCellItem(Item.Properties properties, CableTier tier, int euPerTick, int durationTicks) {
        super(properties.stacksTo(1).durability(0));
        this.tier = tier;
        this.euPerTick = euPerTick;
        this.durationTicks = durationTicks;
    }

    public CableTier getTier() {
        return this.tier;
    }

    public int getEuPerTick() {
        return this.euPerTick;
    }

    public int getDurationTicks() {
        return this.durationTicks;
    }

    public boolean lastsForever() {
        return this.getDurationTicks() == 0;
    }

    public int getSolarTicks(ItemStack stack) {
        return (Integer)stack.getOrDefault(EIComponents.SOLAR_TICKS, (Object)0);
    }

    public int getSolarTicksRemaining(ItemStack stack) {
        return this.getDurationTicks() - this.getSolarTicks(stack);
    }

    public void incrementTick(ItemStack stack) {
        int solarTicks = this.getSolarTicks(stack) + 1;
        if (solarTicks > this.getDurationTicks()) {
            return;
        }
        stack.set(EIComponents.SOLAR_TICKS, (Object)solarTicks);
    }

    public boolean isBarVisible(ItemStack stack) {
        int solarTicks = this.getSolarTicks(stack);
        return solarTicks > 0;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f - (float)this.getSolarTicks(stack) / (float)this.getDurationTicks() * 13.0f);
    }

    public int getBarColor(ItemStack stack) {
        float hue = Math.max(0.0f, (float)this.getSolarTicksRemaining(stack) / (float)this.getDurationTicks());
        return Mth.hsvToRgb((float)(hue / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static long calculateTotalEuProduced(int euPerTick, int durationTicks) {
        int dayLength = 12000;
        int energyProduced = 0;
        for (int tick = 0; tick <= durationTicks; ++tick) {
            int time = tick % dayLength;
            long timeFromNoon = Math.abs(6000 - time);
            float efficiency = 0.0f;
            if (time >= 4000 && time <= 8000) {
                efficiency = 1.0f;
            } else if (time < 4000) {
                efficiency = -6.25E-8f * (float)time * (float)time + 5.0E-4f * (float)time;
            } else if (time > 8000) {
                efficiency = -6.25E-8f * (float)time * (float)time + 0.001f * (float)time - 3.0f;
            }
            energyProduced = (int)((float)energyProduced + (float)euPerTick * efficiency);
        }
        return energyProduced;
    }
}

