/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.items.DynamicToolItem;
import aztech.modern_industrialization.items.ItemHelper;
import aztech.modern_industrialization.util.GeometryHelper;
import com.google.common.collect.Lists;
import dev.technici4n.grandpower.api.ISimpleEnergyItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.swedz.extended_industrialization.EIComponents;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.EITooltips;
import net.swedz.extended_industrialization.item.ToggleableItem;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.helper.ColorHelper;
import net.swedz.tesseract.neoforge.item.DynamicDyedItem;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import net.swedz.tesseract.neoforge.proxy.builtin.TesseractProxy;
import net.swedz.tesseract.neoforge.tooltip.Parser;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

@EventBusSubscriber(modid="extended_industrialization")
public class ElectricToolItem
extends Item
implements DynamicToolItem,
ISimpleEnergyItem,
DynamicDyedItem,
ToggleableItem {
    public static final int SPEED_MIN = 1;
    public static final int SPEED_MAX = 10;
    private static final int SPEED_MULTIPLIER = 10;
    public static final long ENERGY_COST = 2048L;
    private final Type toolType;
    private static MergedDrops MERGED_DROPS = null;
    private static final WeakHashMap<Player, ClickedBlock> LAST_CLICKED_FACE = new WeakHashMap();

    public ElectricToolItem(Item.Properties properties, Type toolType) {
        super(properties.stacksTo(1).rarity(Rarity.UNCOMMON));
        this.toolType = toolType;
    }

    public Type getToolType() {
        return this.toolType;
    }

    public static int getToolSpeed(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof ElectricToolItem)) {
            throw new IllegalArgumentException("Cannot get tool speed for a non electric tool item");
        }
        ElectricToolItem item2 = (ElectricToolItem)item;
        return (Integer)stack.getOrDefault(EIComponents.ELECTRIC_TOOL_SPEED, (Object)10);
    }

    public static void setToolSpeed(ItemStack stack, int speed) {
        speed = Mth.clamp((int)speed, (int)1, (int)10);
        stack.set(EIComponents.ELECTRIC_TOOL_SPEED, (Object)speed);
    }

    public static boolean isFortune(ItemStack stack) {
        return (Boolean)stack.getOrDefault(MIComponents.SILK_TOUCH, (Object)false) == false;
    }

    public static void setFortune(ItemStack stack, boolean fortune) {
        stack.set(MIComponents.SILK_TOUCH, (Object)(!fortune ? 1 : 0));
    }

    public int getDyeColor(DyeColor dyeColor) {
        if (this.toolType == Type.ULTIMATE) {
            return ColorHelper.getVibrantColor((DyeColor)dyeColor);
        }
        throw new UnsupportedOperationException();
    }

    public int getDefaultDyeColor() {
        if (this.toolType == Type.ULTIMATE) {
            return -65536;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setActivated(Player player, ItemStack stack, boolean activated) {
        if (this.toolType.canDo3by3()) {
            ToggleableItem.super.setActivated(player, stack, activated);
            if (!player.level().isClientSide()) {
                player.displayClientMessage((Component)(activated ? EIText.ELECTRIC_TOOL_3_BY_3_TOGGLED_ON : EIText.ELECTRIC_TOOL_3_BY_3_TOGGLED_OFF).text(), true);
            }
        }
    }

    public boolean should3By3(ItemStack stack, Player player) {
        return this.toolType.canDo3by3() && this.isActivated(stack) && !player.isShiftKeyDown();
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    private static void mergeDrops(BlockDropsEvent event) {
        if (MERGED_DROPS == null) {
            return;
        }
        MERGED_DROPS.addAll(event.getDrops(), event.getDroppedExperience());
        event.getDrops().clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    private static void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide()) {
            PlayerInteractEvent.LeftClickBlock.Action action = event.getAction();
            if (action == PlayerInteractEvent.LeftClickBlock.Action.START || action == PlayerInteractEvent.LeftClickBlock.Action.STOP) {
                LAST_CLICKED_FACE.put(player, new ClickedBlock(event.getPos().immutable(), event.getFace()));
            } else if (action == PlayerInteractEvent.LeftClickBlock.Action.ABORT) {
                LAST_CLICKED_FACE.remove(player);
            }
        }
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miner) {
        if (state.getDestroySpeed((BlockGetter)level, pos) > 0.0f) {
            if (miner instanceof Player) {
                Player player = (Player)miner;
                Optional<Area> optionalArea = this.getArea((BlockGetter)level, player, stack, false);
                if (optionalArea.isEmpty()) {
                    this.tryUseEnergy(stack, 2048L);
                    return true;
                }
                LAST_CLICKED_FACE.remove(player);
                Area area = optionalArea.get();
                MERGED_DROPS = new MergedDrops();
                ElectricToolItem.forEachMineableBlock((BlockGetter)level, area, (LivingEntity)player, (minedPos, minedState) -> {
                    Block minedBlock = minedState.getBlock();
                    BlockEntity minedBlockEntity = level.getBlockEntity(minedPos);
                    BlockEvent.BreakEvent event = CommonHooks.fireBlockBreak((Level)level, (GameType)((ServerPlayer)player).gameMode.getGameModeForPlayer(), (ServerPlayer)((ServerPlayer)player), (BlockPos)minedPos, (BlockState)minedState);
                    if (!event.isCanceled() && minedBlock.onDestroyedByPlayer(minedState, level, minedPos, player, true, minedState.getFluidState())) {
                        minedBlock.destroy((LevelAccessor)level, minedPos, minedState);
                        Block.dropResources((BlockState)minedState, (Level)level, (BlockPos)minedPos, (BlockEntity)minedBlockEntity, (Entity)miner, (ItemStack)stack);
                    }
                });
                MERGED_DROPS.drop(level, player, area);
                MERGED_DROPS = null;
                this.tryUseEnergy(stack, 6144L);
            } else {
                this.tryUseEnergy(stack, 2048L);
            }
        }
        return true;
    }

    private static HitResult rayTraceSimple(BlockGetter level, Player player, float partialTicks) {
        double blockReachDistance = player.blockInteractionRange();
        Vec3 eyePos = player.getEyePosition(partialTicks);
        Vec3 viewVector = player.getViewVector(partialTicks);
        Vec3 target = eyePos.add(viewVector.x * blockReachDistance, viewVector.y * blockReachDistance, viewVector.z * blockReachDistance);
        return level.clip(new ClipContext(eyePos, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
    }

    public Optional<Area> getArea(BlockGetter level, Player player, ItemStack stack, boolean rayTraceOnly) {
        ClickedBlock clickedBlock;
        if (!this.should3By3(stack, player)) {
            return Optional.empty();
        }
        if (!rayTraceOnly && (clickedBlock = LAST_CLICKED_FACE.get(player)) != null) {
            return Optional.of(Area.of(clickedBlock.pos(), clickedBlock.face()));
        }
        HitResult rayTraceResult = ElectricToolItem.rayTraceSimple(level, player, 0.0f);
        if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockResult = (BlockHitResult)rayTraceResult;
            Direction facing = blockResult.getDirection();
            return Optional.of(Area.of(blockResult.getBlockPos(), facing));
        }
        return Optional.empty();
    }

    private boolean isMineableBlock(ItemStack stack, BlockState state, BlockGetter level, BlockPos pos) {
        return !state.isAir() && state.getDestroySpeed(level, pos) > 0.0f && this.isValidForBlock(stack, state);
    }

    public static void forEachMineableBlock(BlockGetter level, Area area, LivingEntity miner, BiConsumer<BlockPos, BlockState> callback) {
        Player player;
        ItemStack stack;
        Item item;
        if (miner instanceof Player && (item = (stack = (player = (Player)miner).getMainHandItem()).getItem()) instanceof ElectricToolItem) {
            ElectricToolItem tool = (ElectricToolItem)item;
            BlockState centerState = level.getBlockState(area.center());
            if (!tool.isMineableBlock(stack, centerState, level, area.center())) {
                return;
            }
            callback.accept(area.center(), centerState);
            BlockPos.betweenClosed((BlockPos)area.cornerFirst(), (BlockPos)area.cornerSecond()).forEach(pos -> {
                BlockState state;
                if (level.getBlockEntity(pos) == null && !area.center().equals(pos) && tool.isMineableBlock(stack, state = level.getBlockState(pos), level, (BlockPos)pos)) {
                    callback.accept((BlockPos)pos, state);
                }
            });
        }
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.tryUseEnergy(stack, 2048L);
        return true;
    }

    private boolean isValidForBlock(ItemStack stack, BlockState state) {
        return this.isSupportedBlock(stack, state) && !state.is(Tiers.NETHERITE.getIncorrectBlocksForDrops());
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.getStoredEnergy(stack) > 0L && this.isValidForBlock(stack, state) || super.isCorrectToolForDrops(stack, state);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.getStoredEnergy(stack) > 0L) {
            if (this.isValidForBlock(stack, state)) {
                float speed = ElectricToolItem.getToolSpeed(stack) * 10;
                Optional player = ((TesseractProxy)Proxies.get(TesseractProxy.class)).findUserWithItem(EquipmentSlot.MAINHAND, stack);
                if (player.isPresent() && this.should3By3(stack, (Player)player.get())) {
                    speed /= 4.0f;
                }
                return speed;
            }
            return 1.0f;
        }
        return 0.0f;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return this.getStoredEnergy(stack) > 0L ? ItemHelper.getToolModifiers((double)this.toolType.damage()) : ItemAttributeModifiers.EMPTY;
    }

    public boolean isBarVisible(ItemStack stack) {
        return (Boolean)stack.getOrDefault(EIComponents.HIDE_BAR, (Object)false) == false;
    }

    public int getBarWidth(ItemStack stack) {
        return (int)Math.round((double)this.getStoredEnergy(stack) / (double)this.toolType.energyCapacity() * 13.0);
    }

    public int getBarColor(ItemStack stack) {
        return 0xFF0000;
    }

    public long getEnergyCapacity(ItemStack stack) {
        return this.toolType.energyCapacity();
    }

    public long getEnergyMaxInput(ItemStack stack) {
        return this.toolType.energyCapacity();
    }

    public long getEnergyMaxOutput(ItemStack stack) {
        return this.toolType.energyCapacity();
    }

    private static Component enchantmentFullNameComponent(HolderLookup.RegistryLookup<Enchantment> enchantmentRegistry, ResourceKey<Enchantment> enchantment) {
        Holder.Reference fortune = enchantmentRegistry.getOrThrow(enchantment);
        return Enchantment.getFullname((Holder)fortune, (int)((Enchantment)fortune.value()).getMaxLevel());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)MICompatibleTextLine.line((TranslatableTextEnum)EIText.MINING_SPEED).arg((Object)Float.valueOf((float)ElectricToolItem.getToolSpeed(stack) / 10.0f), EITooltips.SPACED_PERCENTAGE_PARSER));
        if (this.toolType.canDo3by3()) {
            tooltip.add((Component)MICompatibleTextLine.line((TranslatableTextEnum)EIText.MINING_AREA).arg((Object)(this.isActivated(stack) ? EIText.MINING_AREA_3_BY_3 : EIText.MINING_AREA_1_BY_1).text().withStyle(MITooltips.NUMBER_TEXT)));
        }
        if (context.registries() != null) {
            tooltip.add((Component)MICompatibleTextLine.line((TranslatableTextEnum)EIText.MINING_MODE).arg((Object)context.registries(), (Object)(ElectricToolItem.isFortune(stack) ? Enchantments.FORTUNE : Enchantments.SILK_TOUCH), Parser.ENCHANTMENT.withStyle(MITooltips.NUMBER_TEXT)));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && user.isShiftKeyDown()) {
            ItemStack stack;
            ElectricToolItem.setFortune(stack, !ElectricToolItem.isFortune(stack = user.getItemInHand(hand)));
            if (!world.isClientSide) {
                user.displayClientMessage((Component)(ElectricToolItem.isFortune(stack) ? MIText.ToolSwitchedFortune.text() : MIText.ToolSwitchedSilkTouch.text()), true);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
        }
        return super.use(world, user, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        if (this.getStoredEnergy(stack) > 0L) {
            BlockState newState;
            Block newBlock;
            if (stack.is(ItemTags.AXES) && (newBlock = StrippingAccess.getStrippedBlocks().get(state.getBlock())) != null) {
                level.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.isClientSide) {
                    level.setBlock(pos, (BlockState)newBlock.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS))), 11);
                    this.tryUseEnergy(stack, 2048L);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.is(ItemTags.SHOVELS) && (newState = PathingAccess.getPathStates().get(state.getBlock())) != null) {
                level.playSound(player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.isClientSide) {
                    level.setBlock(pos, newState, 11);
                    this.tryUseEnergy(stack, 2048L);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useOn(context);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        Level level = interactionTarget.level();
        BlockPos blockPos = interactionTarget.blockPosition();
        if (this.getStoredEnergy(stack) > 0L && stack.is(Tags.Items.TOOLS_SHEAR) && interactionTarget instanceof IShearable) {
            IShearable shearable = (IShearable)interactionTarget;
            if (!level.isClientSide && shearable.isShearable(player, stack, level, blockPos)) {
                this.tryUseEnergy(stack, 2048L);
                shearable.onSheared(player, stack, level, blockPos).forEach(drop -> shearable.spawnShearedDrop(level, blockPos, drop));
                interactionTarget.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public int getEnchantmentLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        return this.getAllEnchantments(stack, (HolderLookup.RegistryLookup<Enchantment>)enchantment.unwrapLookup()).getLevel(enchantment);
    }

    private static void includeEnchantment(HolderLookup.RegistryLookup<Enchantment> lookup, ItemEnchantments.Mutable enchantments, ResourceKey<Enchantment> enchantment) {
        lookup.get(enchantment).ifPresent(ench -> enchantments.set((Holder)ench, ((Enchantment)ench.value()).getMaxLevel()));
    }

    public ItemEnchantments getAllEnchantments(ItemStack stack, HolderLookup.RegistryLookup<Enchantment> lookup) {
        ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(super.getAllEnchantments(stack, lookup));
        if (this.getStoredEnergy(stack) > 0L) {
            if (ElectricToolItem.isFortune(stack)) {
                ElectricToolItem.includeEnchantment(lookup, enchantments, (ResourceKey<Enchantment>)Enchantments.FORTUNE);
                if (this.toolType.includeLooting()) {
                    ElectricToolItem.includeEnchantment(lookup, enchantments, (ResourceKey<Enchantment>)Enchantments.LOOTING);
                }
            } else {
                ElectricToolItem.includeEnchantment(lookup, enchantments, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH);
            }
        }
        return enchantments.toImmutable();
    }

    public boolean isFoil(ItemStack stack) {
        return this.getStoredEnergy(stack) > 0L;
    }

    public DataComponentType<Long> getEnergyComponent() {
        return (DataComponentType)MIComponents.ENERGY.get();
    }

    public static enum Type {
        DRILL(1200L * CableTier.HV.getMaxTransfer(), 8, false, true),
        CHAINSAW(1200L * CableTier.HV.getMaxTransfer(), 10, true, false),
        ULTIMATE(1200L * CableTier.EV.getMaxTransfer(), 20, true, true);

        private final long energyCapacity;
        private final int damage;
        private final boolean includeLooting;
        private final boolean canDo3by3;

        private Type(long energyCapacity, int damage, boolean includeLooting, boolean canDo3by3) {
            this.energyCapacity = energyCapacity;
            this.damage = damage;
            this.includeLooting = includeLooting;
            this.canDo3by3 = canDo3by3;
        }

        public long energyCapacity() {
            return this.energyCapacity;
        }

        public int damage() {
            return this.damage;
        }

        public boolean includeLooting() {
            return this.includeLooting;
        }

        public boolean canDo3by3() {
            return this.canDo3by3;
        }
    }

    private record MergedDrops(List<ItemStack> totalDrops) {
        private MergedDrops() {
            this(Lists.newArrayList());
        }

        private void addAll(List<ItemEntity> droppedItems, int droppedExperience) {
            block0: for (ItemEntity drop : droppedItems) {
                ItemStack dropItem = drop.getItem();
                for (ItemStack totalDrop : this.totalDrops) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)dropItem, (ItemStack)totalDrop)) continue;
                    totalDrop.grow(dropItem.getCount());
                    continue block0;
                }
                this.totalDrops.add(dropItem);
            }
        }

        public void drop(Level level, Player player, Area area) {
            BlockPos pos = player.blockPosition();
            this.totalDrops.forEach(drop -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)drop));
            level.getEntitiesOfClass(ExperienceOrb.class, new AABB(Vec3.atLowerCornerOf((Vec3i)area.cornerFirst()), Vec3.atLowerCornerOf((Vec3i)area.cornerSecond())).inflate(1.0)).forEach(orb -> orb.teleportTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
        }
    }

    private record ClickedBlock(BlockPos pos, Direction face) {
    }

    public record Area(BlockPos center, BlockPos cornerFirst, BlockPos cornerSecond) {
        public static Area of(BlockPos pos, Direction hitFace) {
            int face = hitFace.get3DDataValue();
            Vec3 right = GeometryHelper.FACE_RIGHT[face];
            int rightX = (int)right.x();
            int rightY = (int)right.y();
            int rightZ = (int)right.z();
            Vec3 up = GeometryHelper.FACE_UP[face];
            int upX = (int)up.x();
            int upY = (int)up.y();
            int upZ = (int)up.z();
            return new Area(pos, pos.offset(rightX + upX, rightY + upY, rightZ + upZ), pos.offset(-rightX - upX, -rightY - upY, -rightZ - upZ));
        }
    }

    private static class StrippingAccess
    extends AxeItem {
        private StrippingAccess(Tier material, Item.Properties properties) {
            super(material, properties);
        }

        public static Map<Block, Block> getStrippedBlocks() {
            return AxeItem.STRIPPABLES;
        }
    }

    private static class PathingAccess
    extends ShovelItem {
        private PathingAccess(Tier material, Item.Properties properties) {
            super(material, properties);
        }

        public static Map<Block, BlockState> getPathStates() {
            return ShovelItem.FLATTENABLES;
        }
    }
}

