/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.server.provider.tags;

import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EITags;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class ItemTagDatagenProvider
extends ItemTagsProvider {
    public ItemTagDatagenProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider(), CompletableFuture.completedFuture(TagsProvider.TagLookup.empty()), "extended_industrialization", event.getExistingFileHelper());
    }

    private void addFarmerVoidableDropTag() {
        this.tag(EITags.Items.FARMER_VOIDABLE).add((Object[])new Item[]{Items.STICK, Items.APPLE, Items.MOSS_CARPET, Items.MANGROVE_ROOTS}).addTags(new TagKey[]{ItemTags.SAPLINGS});
    }

    private void addFarmerStandardPlantableTag() {
        this.tag(EITags.Items.FARMER_PLANTABLE).addTags(new TagKey[]{Tags.Items.SEEDS, Tags.Items.CROPS, ItemTags.VILLAGER_PLANTABLE_SEEDS, ItemTags.SAPLINGS}).remove((Object)Items.BEETROOT, (Object[])new Item[]{Items.WHEAT});
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (ItemHolder item2 : EIItems.values().stream().sorted(Comparator.comparing(item -> item.identifier().id())).toList()) {
            for (TagKey tag : item2.tags()) {
                this.tag(tag).add((Object)item2.asItem());
            }
        }
        this.addFarmerVoidableDropTag();
        this.addFarmerStandardPlantableTag();
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

