/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.server.provider.recipes;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import aztech.modern_industrialization.materials.MIMaterials;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import java.util.function.Consumer;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIBlocks;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.datagen.api.recipe.ShapedRecipeBuilder;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.RecipesServerDatagenProvider;

public final class CommonRecipesServerDatagenProvider
extends RecipesServerDatagenProvider {
    public CommonRecipesServerDatagenProvider(GatherDataEvent event) {
        super(event);
    }

    private static void addBasicCraftingRecipes(String path, String name, boolean assembler, ItemLike result, int resultCount, Consumer<ShapedRecipeBuilder> crafting, RecipeOutput output) {
        ShapedRecipeBuilder shapedRecipeBuilder = new ShapedRecipeBuilder();
        crafting.accept(shapedRecipeBuilder);
        shapedRecipeBuilder.setOutput(result, resultCount);
        shapedRecipeBuilder.offerTo(output, EI.id(path + "/craft/" + name));
        if (assembler) {
            shapedRecipeBuilder.exportToAssembler().offerTo(output, EI.id(path + "/assembler/" + name));
        }
    }

    private static void components(RecipeOutput output) {
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("component", "netherite_rotary_blade", true, EIItems.NETHERITE_ROTARY_BLADE, 1, r -> r.define('N', EITags.itemCommon("dusts/netherite")).define('R', EITags.itemCommon("gears/stainless_steel")).pattern(" N ").pattern("NRN").pattern(" N "), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("component", "steel_combine", false, EIItems.STEEL_COMBINE, 1, r -> r.define('C', "modern_industrialization:steel_curved_plate").define('B', "modern_industrialization:steel_bolt").define('R', EITags.itemCommon("rods/steel")).pattern("CCC").pattern("BRB").pattern("CCC"), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("component/assembler", "steel_combine", MIMachineRecipeTypes.ASSEMBLER, 8, 200, b -> ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)b.addItemInput("modern_industrialization:steel_curved_plate", 6)).addItemInput(EITags.itemCommon("rods/steel"), 1)).addFluidInput((FluidLike)MIFluids.SOLDERING_ALLOY, 50)).addItemOutput(EIItems.STEEL_COMBINE, 1), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("component", "tin_can", true, EIItems.TIN_CAN, 2, r -> r.define('T', "modern_industrialization:tin_curved_plate").pattern("T").pattern("T"), output);
    }

    private static void photovoltaicCells(RecipeOutput output) {
        CommonRecipesServerDatagenProvider.addMachineRecipe("photovoltaic_cell", "lv", MIMachineRecipeTypes.PACKER, 4, 800, r -> ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput(EITags.itemCommon("plates/silver"), 2)).addItemInput("modern_industrialization:rubber_sheet", 4)).addItemOutput(EIItems.LV_PHOTOVOLTAIC_CELL, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("photovoltaic_cell", "lv_synthetic_rubber", MIMachineRecipeTypes.ASSEMBLER, 8, 800, r -> ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput(EITags.itemCommon("plates/silver"), 2)).addFluidInput((FluidLike)MIFluids.SYNTHETIC_RUBBER, 20)).addItemOutput(EIItems.LV_PHOTOVOLTAIC_CELL, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("photovoltaic_cell", "lv_styrene_rubber", MIMachineRecipeTypes.ASSEMBLER, 8, 800, r -> ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput(EITags.itemCommon("plates/silver"), 2)).addFluidInput((FluidLike)MIFluids.STYRENE_BUTADIENE_RUBBER, 4)).addItemOutput(EIItems.LV_PHOTOVOLTAIC_CELL, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("photovoltaic_cell", "mv", MIMachineRecipeTypes.ASSEMBLER, 8, 800, r -> ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput("modern_industrialization:silicon_n_doped_plate", 1)).addItemInput(EITags.itemCommon("plates/silver"), 4)).addItemInput("modern_industrialization:silicon_p_doped_plate", 1)).addFluidInput((FluidLike)MIFluids.SYNTHETIC_RUBBER, 100)).addItemOutput(EIItems.MV_PHOTOVOLTAIC_CELL, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("photovoltaic_cell", "mv_styrene_rubber", MIMachineRecipeTypes.ASSEMBLER, 8, 800, r -> ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput("modern_industrialization:silicon_n_doped_plate", 1)).addItemInput(EITags.itemCommon("plates/silver"), 4)).addItemInput("modern_industrialization:silicon_p_doped_plate", 1)).addFluidInput((FluidLike)MIFluids.STYRENE_BUTADIENE_RUBBER, 20)).addItemOutput(EIItems.MV_PHOTOVOLTAIC_CELL, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("photovoltaic_cell", "hv", MIMachineRecipeTypes.ASSEMBLER, 8, 800, r -> ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput("modern_industrialization:silicon_wafer", 4)).addItemInput(EITags.itemCommon("plates/silver"), 8)).addFluidInput((FluidLike)MIFluids.SYNTHETIC_RUBBER, 200)).addFluidInput((FluidLike)MIFluids.POLYETHYLENE, 500)).addItemOutput(EIItems.HV_PHOTOVOLTAIC_CELL, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("photovoltaic_cell", "hv_styrene_rubber", MIMachineRecipeTypes.ASSEMBLER, 8, 800, r -> ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput("modern_industrialization:silicon_wafer", 4)).addItemInput(EITags.itemCommon("plates/silver"), 8)).addFluidInput((FluidLike)MIFluids.STYRENE_BUTADIENE_RUBBER, 40)).addFluidInput((FluidLike)MIFluids.POLYETHYLENE, 500)).addItemOutput(EIItems.HV_PHOTOVOLTAIC_CELL, 1), output);
    }

    private static void nanoSuitPiece(String id, ItemLike baseArmor, int pieces, ItemLike result, Consumer<MachineRecipeBuilder> recipeBuilder, RecipeOutput output) {
        CommonRecipesServerDatagenProvider.addMachineRecipe("tool", id, MIMachineRecipeTypes.ASSEMBLER, 8, 200, builder -> {
            ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)builder.addItemInput(baseArmor, 1)).addItemInput(EITags.itemCommon("plates/carbon"), 4 * pieces)).addItemInput((ItemLike)MIItem.ELECTRONIC_CIRCUIT, 4)).addItemInput("modern_industrialization:silicon_battery", 2)).addItemInput((ItemLike)MIItem.LARGE_MOTOR, 4)).addFluidInput((FluidLike)MIFluids.POLYETHYLENE, 4000)).addFluidInput((FluidLike)MIFluids.NYLON, 2000)).addItemOutput(result, 1);
            if (recipeBuilder != null) {
                recipeBuilder.accept((MachineRecipeBuilder)builder);
            }
        }, output);
    }

    private static void nanoSuit(RecipeOutput output) {
        CommonRecipesServerDatagenProvider.nanoSuitPiece("nano_suit_helmet", (ItemLike)Items.NETHERITE_HELMET, 5, EIItems.NANO_HELMET, r -> ((MachineRecipeBuilder)r.addItemInput(EITags.itemCommon("glass_panes"), 4)).addItemInput((ItemLike)MIItem.REDSTONE_CONTROL_MODULE, 1), output);
        CommonRecipesServerDatagenProvider.nanoSuitPiece("nano_suit_chestplate", (ItemLike)Items.NETHERITE_CHESTPLATE, 8, EIItems.NANO_CHESTPLATE, null, output);
        CommonRecipesServerDatagenProvider.nanoSuitPiece("nano_suit_leggings", (ItemLike)Items.NETHERITE_LEGGINGS, 7, EIItems.NANO_LEGGINGS, null, output);
        CommonRecipesServerDatagenProvider.nanoSuitPiece("nano_suit_boots", (ItemLike)Items.NETHERITE_BOOTS, 4, EIItems.NANO_BOOTS, null, output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("tool", "nano_suit_gravichestplate_upgrade", MIMachineRecipeTypes.PACKER, 32, 200, b -> ((MachineRecipeBuilder)((MachineRecipeBuilder)b.addItemInput(EIItems.NANO_CHESTPLATE, 1)).addItemInput((ItemLike)MIItem.GRAVICHESTPLATE, 1)).addItemOutput(EIItems.NANO_GRAVICHESTPLATE, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("tool", "nano_suit_gravichestplate_downgrade", MIMachineRecipeTypes.UNPACKER, 32, 200, b -> ((MachineRecipeBuilder)((MachineRecipeBuilder)b.addItemInput(EIItems.NANO_GRAVICHESTPLATE, 1)).addItemOutput(EIItems.NANO_CHESTPLATE, 1)).addItemOutput((ItemLike)MIItem.GRAVICHESTPLATE, 1), output);
    }

    protected void buildRecipes(RecipeOutput output) {
        CommonRecipesServerDatagenProvider.addMachineRecipe("mixer", "mulch", MIMachineRecipeTypes.MIXER, 2, 100, r -> ((MachineRecipeBuilder)((MachineRecipeBuilder)r.addItemInput((ItemLike)Items.DIRT, 1)).addItemInput((ItemLike)MIItem.WOOD_PULP, 6)).addItemOutput(EIItems.MULCH, 1), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("macerator", "granite_dust", MIMachineRecipeTypes.MACERATOR, 2, 100, r -> ((MachineRecipeBuilder)r.addItemInput((ItemLike)Items.GRANITE, 1)).addItemOutput(EIItems.GRANITE_DUST, 4), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("compacting", "granite_from_dust", false, (ItemLike)Items.GRANITE, 1, r -> r.define('G', (ItemLike)EIItems.GRANITE_DUST).pattern("GG").pattern("GG"), output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("packer", "granite_from_dust", MIMachineRecipeTypes.PACKER, 2, 100, r -> ((MachineRecipeBuilder)r.addItemInput(EITags.itemCommon("dusts/granite"), 4)).addItemOutput(Items.GRANITE, 1), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("casing", "steel_plated_bricks", true, (ItemLike)EIBlocks.STEEL_PLATED_BRICKS.get().asItem(), 1, r -> r.define('S', (ItemLike)MIMaterials.STEEL.getPart((PartKeyProvider)MIParts.PLATE)).define('B', "modern_industrialization:fire_clay_bricks").pattern("SSS").pattern("SBS").pattern("SSS"), output);
        CommonRecipesServerDatagenProvider.components(output);
        CommonRecipesServerDatagenProvider.addMachineRecipe("distillery", "distilled_water_from_water", MIMachineRecipeTypes.DISTILLERY, 8, 200, r -> ((MachineRecipeBuilder)r.addFluidInput((Fluid)Fluids.WATER, 1000)).addFluidOutput((FluidLike)EIFluids.DISTILLED_WATER, 500), output);
        CommonRecipesServerDatagenProvider.photovoltaicCells(output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("tool", "steam_chainsaw", false, EIItems.STEAM_CHAINSAW, 1, r -> r.define('F', (ItemLike)Items.FURNACE).define('D', (ItemLike)Items.DIAMOND).define('P', "modern_industrialization:iron_large_plate").define('C', EITags.itemCommon("gears/copper")).define('B', (ItemLike)Items.BUCKET).pattern("FDD").pattern("PCD").pattern("BPF"), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("tool", "electric_chainsaw", false, EIItems.ELECTRIC_CHAINSAW, 1, r -> r.define('U', (ItemLike)MIItem.ADVANCED_UPGRADE).define('R', (ItemLike)MIItem.RUBBER_SHEET).define('B', (ItemLike)EIItems.NETHERITE_ROTARY_BLADE).define('M', (ItemLike)MIItem.ADVANCED_MOTOR).define('C', "modern_industrialization:aluminum_cable").pattern("URB").pattern("MBR").pattern("CMU"), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("tool", "electric_mining_drill", false, EIItems.ELECTRIC_MINING_DRILL, 1, r -> r.define('U', (ItemLike)MIItem.ADVANCED_UPGRADE).define('R', (ItemLike)EIItems.NETHERITE_ROTARY_BLADE).define('D', "modern_industrialization:stainless_steel_drill_head").define('M', (ItemLike)MIItem.ADVANCED_MOTOR).define('L', (ItemLike)MIItem.LARGE_MOTOR).define('C', "modern_industrialization:aluminum_cable").pattern("URD").pattern("MLR").pattern("CMU"), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("tool", "machine_config_card", false, EIItems.MACHINE_CONFIG_CARD, 1, r -> r.define('G', EITags.itemCommon("glass_panes")).define('I', "modern_industrialization:inductor").define('C', "modern_industrialization:capacitor").define('M', "modern_industrialization:motor").define('A', "modern_industrialization:analog_circuit_board").pattern("GGG").pattern("ICI").pattern("MAM"), output);
        CommonRecipesServerDatagenProvider.addBasicCraftingRecipes("tool", "ultimate_drill", false, EIItems.ULTIMATE_LASER_DRILL, 1, r -> r.define('D', (ItemLike)EIItems.ELECTRIC_MINING_DRILL).define('B', (ItemLike)EIItems.NETHERITE_ROTARY_BLADE).define('C', (ItemLike)EIItems.ELECTRIC_CHAINSAW).define('c', "modern_industrialization:cooling_cell").define('S', "modern_industrialization:superconductor_coil").define('U', "modern_industrialization:highly_advanced_upgrade").define('s', "modern_industrialization:superconductor_cable").pattern("DBC").pattern("cSc").pattern("UsU"), output);
        CommonRecipesServerDatagenProvider.nanoSuit(output);
    }
}

