/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.client.provider;

import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EIKeybinds;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.EIText;
import net.swedz.tesseract.neoforge.datagen.mi.MIDatagenHooks;
import net.swedz.tesseract.neoforge.registry.holder.FluidHolder;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class LanguageDatagenProvider
extends LanguageProvider {
    public LanguageDatagenProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), "extended_industrialization", "en_us");
    }

    protected void addTranslations() {
        for (EIText text : EIText.values()) {
            this.add(text.getTranslationKey(), text.englishText());
        }
        for (ItemHolder item : EIItems.values()) {
            this.add(item.asItem(), item.identifier().englishName());
        }
        for (FluidHolder fluid : EIFluids.values()) {
            this.add(fluid.block().get(), fluid.identifier().englishName());
        }
        for (EIKeybinds.Keybind keybind : EIKeybinds.Registry.getMappings()) {
            this.add(keybind.descriptionId(), keybind.englishName());
        }
        EITags.translations().forEach((arg_0, arg_1) -> ((LanguageDatagenProvider)this).add(arg_0, arg_1));
        MIDatagenHooks.Client.withLanguageHook((LanguageProvider)this, (String)"extended_industrialization");
        this.add("itemGroup.%s.%s".formatted("extended_industrialization", "extended_industrialization"), "Extended Industrialization");
        this.add(EIKeybinds.CATEGORY, "Extended Industrialization");
        this.add("lef_tier.%s.%s.%s".formatted("extended_industrialization", "modern_industrialization", "cupronickel_coil"), "Cupronickel");
        this.add("lef_tier.%s.%s.%s".formatted("extended_industrialization", "modern_industrialization", "kanthal_coil"), "Kanthal");
    }
}

