/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.api.recipe;

import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.swedz.extended_industrialization.datagen.api.MachineRecipeBuilderWrapper;
import net.swedz.extended_industrialization.datagen.api.RecipeHelper;
import net.swedz.extended_industrialization.datagen.api.recipe.RecipeBuilder;

public class ShapedRecipeBuilder
extends RecipeBuilder<ShapedRecipeBuilder> {
    private final Map<Character, Ingredient> key = Maps.newHashMap();
    private final List<String> pattern = Lists.newArrayList();

    public ShapedRecipeBuilder define(char key, Ingredient ingredient) {
        if (this.key.put(Character.valueOf(key), ingredient) != null) {
            throw new IllegalStateException("Key mapping is already registered: " + key);
        }
        return this;
    }

    public ShapedRecipeBuilder define(char key, ItemLike item) {
        return this.define(key, Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public ShapedRecipeBuilder define(char key, TagKey<Item> tag) {
        return this.define(key, Ingredient.of(tag));
    }

    public ShapedRecipeBuilder define(char key, String maybeTag) {
        return this.define(key, RecipeHelper.ingredient(maybeTag));
    }

    public ShapedRecipeBuilder pattern(String line) {
        this.pattern.add(line);
        return this;
    }

    @Override
    public void validate() {
        if (this.pattern.size() == 0 || this.pattern.size() > 3) {
            throw new IllegalArgumentException("Invalid length " + this.pattern.size());
        }
        for (String string : this.pattern) {
            if (string.length() == this.pattern.get(0).length()) continue;
            throw new IllegalArgumentException("Pattern length mismatch: " + string.length() + ", expected " + this.pattern.get(0).length());
        }
        for (String string : this.pattern) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == ' ' || this.key.containsKey(Character.valueOf(string.charAt(i)))) continue;
                throw new IllegalArgumentException("Key " + string.charAt(i) + " is missing a mapping.");
            }
        }
        Iterator<Object> iterator = this.key.keySet().iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            boolean ok = false;
            block4: for (String string : this.pattern) {
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) != c) continue;
                    ok = true;
                    continue block4;
                }
            }
            if (ok) continue;
            throw new IllegalArgumentException("Key mapping '" + c + "' is not used in the pattern.");
        }
    }

    @Override
    public MachineRecipeBuilderWrapper exportToMachine(MachineRecipeType machine, int eu, int duration, int division) {
        if (this.result.getCount() % division != 0) {
            throw new IllegalArgumentException("Output must be divisible by division");
        }
        MachineRecipeBuilder assemblerRecipe = (MachineRecipeBuilder)new MachineRecipeBuilder(machine, eu, duration).addItemOutput(this.result.getItem(), this.result.getCount() / division);
        for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
            int count = 0;
            for (String row : this.pattern) {
                for (char c : row.toCharArray()) {
                    if (c != entry.getKey().charValue()) continue;
                    ++count;
                }
            }
            if (count % division != 0) {
                throw new IllegalArgumentException("Input must be divisible by division");
            }
            assemblerRecipe.addItemInput(entry.getValue(), count / division, 1.0f);
        }
        return new MachineRecipeBuilderWrapper(assemblerRecipe);
    }

    @Override
    public Recipe<?> convert() {
        return new ShapedRecipe("", CraftingBookCategory.MISC, ShapedRecipePattern.of(this.key, this.pattern), this.result);
    }
}

