/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.EnergyApi;
import com.google.common.collect.Lists;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIConfig;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.item.ElectricToolItem;
import net.swedz.extended_industrialization.item.PhotovoltaicCellItem;
import net.swedz.extended_industrialization.item.nanosuit.NanoSuitArmorItem;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.LargeElectricFurnaceBlockEntity;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.tooltip.BiParser;
import net.swedz.tesseract.neoforge.tooltip.Parser;
import net.swedz.tesseract.neoforge.tooltip.TooltipAttachment;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

public final class EITooltips {
    private static final BiParser<Boolean, Float> MAYBE_SPACED_PERCENTAGE_PARSER = (space, ratio) -> Component.literal((String)"%d%s%%".formatted((int)(ratio.floatValue() * 100.0f), space != false ? " " : "")).withStyle(MITooltips.NUMBER_TEXT);
    public static final Parser<Float> PERCENTAGE_PARSER = ratio -> MAYBE_SPACED_PERCENTAGE_PARSER.parse((Object)false, ratio);
    public static final Parser<Float> SPACED_PERCENTAGE_PARSER = ratio -> MAYBE_SPACED_PERCENTAGE_PARSER.parse((Object)true, ratio);
    public static final Parser<Long> TICKS_TO_MINUTES_PARSER = ticks -> {
        float minutes = (float)ticks.longValue() / 1200.0f;
        return Component.literal((String)"%.2f".formatted(Float.valueOf(minutes))).withStyle(MITooltips.NUMBER_TEXT);
    };
    public static final Parser<Integer> NUMBERED_LIST_BULLET_PARSER = number -> Component.literal((String)"%d)".formatted(number)).withStyle(MITooltips.NUMBER_TEXT);
    public static final Parser<Boolean> ACTIVATED_BOOLEAN_PARSER = value -> value != false ? EIText.ACTIVATED.text().withStyle(ChatFormatting.GREEN) : EIText.DEACTIVATED.text().withStyle(ChatFormatting.RED);
    public static final Parser<String> KEYBIND_PARSER = Parser.KEYBIND.withStyle(MITooltips.NUMBER_TEXT);
    public static final TooltipAttachment ENERGY_STORED_ITEM = TooltipAttachment.singleLineOptional((stack, item) -> BuiltInRegistries.ITEM.getKey((Object)item).getNamespace().equals("extended_industrialization"), (stack, item) -> {
        long capacity;
        ILongEnergyStorage energyStorage = (ILongEnergyStorage)stack.getCapability(EnergyApi.ITEM);
        if (energyStorage != null && (capacity = energyStorage.getCapacity()) > 0L) {
            return Optional.of(MICompatibleTextLine.line((MIText)MIText.EnergyStored).arg((Object)new MITooltips.NumberWithMax((Number)energyStorage.getAmount(), (Number)capacity), MITooltips.EU_MAXED_PARSER));
        }
        return Optional.empty();
    }).noShiftRequired();
    public static final TooltipAttachment MULCH_GANG_FOR_LIFE = TooltipAttachment.multilines(EIItems.MULCH, List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.MULCH_GANG_FOR_LIFE_0, (Style)MITooltips.DEFAULT_STYLE.withItalic(Boolean.valueOf(true))), MICompatibleTextLine.line((TranslatableTextEnum)EIText.MULCH_GANG_FOR_LIFE_1, (Style)MITooltips.DEFAULT_STYLE.withItalic(Boolean.valueOf(true))))).noShiftRequired();
    public static final TooltipAttachment COILS = TooltipAttachment.singleLine((stack, item) -> {
        if (!(item instanceof BlockItem)) return false;
        BlockItem blockItem = (BlockItem)item;
        if (!LargeElectricFurnaceBlockEntity.getTiersByCoil().containsKey(BuiltInRegistries.BLOCK.getKey((Object)blockItem.getBlock()))) return false;
        return true;
    }, (stack, item) -> {
        LargeElectricFurnaceBlockEntity.Tier tier = LargeElectricFurnaceBlockEntity.getTiersByCoil().get(BuiltInRegistries.BLOCK.getKey((Object)((BlockItem)stack.getItem()).getBlock()));
        int batchSize = tier.batchSize();
        float euCostMultiplier = tier.euCostMultiplier();
        return MICompatibleTextLine.line((TranslatableTextEnum)EIText.COILS_LEF_TIER).arg((Object)batchSize).arg((Object)Float.valueOf(euCostMultiplier), PERCENTAGE_PARSER);
    });
    public static final TooltipAttachment PHOTOVOLTAIC_CELLS = TooltipAttachment.multilines(PhotovoltaicCellItem.class, (stack, item) -> {
        int euPerTick = item.getEuPerTick();
        ArrayList lines = Lists.newArrayList();
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.PHOTOVOLTAIC_CELL_EU).arg((Object)euPerTick, MITooltips.EU_PER_TICK_PARSER));
        if (!item.lastsForever()) {
            int solarTicksRemaining = item.getSolarTicksRemaining(stack);
            lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.PHOTOVOLTAIC_CELL_REMAINING_OPERATION_TIME_MINUTES).arg((Object)solarTicksRemaining, TICKS_TO_MINUTES_PARSER));
        } else {
            lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.PHOTOVOLTAIC_CELL_REMAINING_OPERATION_TIME).arg((Object)Component.literal((String)"\u221e").withStyle(MITooltips.NUMBER_TEXT)));
        }
        return lines;
    });
    public static final TooltipAttachment STEAM_CHAINSAW = TooltipAttachment.multilines(EIItems.STEAM_CHAINSAW, List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.STEAM_CHAINSAW_1).arg((Object)"use", KEYBIND_PARSER), MICompatibleTextLine.line((TranslatableTextEnum)EIText.STEAM_CHAINSAW_2).arg((Object)"use", KEYBIND_PARSER), MICompatibleTextLine.line((TranslatableTextEnum)EIText.STEAM_CHAINSAW_3).arg((Object)"sneak", KEYBIND_PARSER).arg((Object)"use", KEYBIND_PARSER)));
    public static final TooltipAttachment MACHINE_CONFIG_CARD = TooltipAttachment.multilines(EIItems.MACHINE_CONFIG_CARD, List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.MACHINE_CONFIG_CARD_HELP_1).arg((Object)"sneak", KEYBIND_PARSER).arg((Object)"use", KEYBIND_PARSER), MICompatibleTextLine.line((TranslatableTextEnum)EIText.MACHINE_CONFIG_CARD_HELP_2).arg((Object)"use", KEYBIND_PARSER), MICompatibleTextLine.line((TranslatableTextEnum)EIText.MACHINE_CONFIG_CARD_HELP_3), MICompatibleTextLine.line((TranslatableTextEnum)EIText.MACHINE_CONFIG_CARD_HELP_4).arg((Object)"sneak", KEYBIND_PARSER).arg((Object)"use", KEYBIND_PARSER)));
    public static final TooltipAttachment ELECTRIC_TOOL_HELP = TooltipAttachment.multilines(ElectricToolItem.class, (stack, item) -> {
        ArrayList lines = Lists.newArrayList();
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.ELECTRIC_TOOL_HELP_1));
        if (stack.is(ItemTags.DYEABLE)) {
            lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.DYEABLE_HELP));
        }
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)(item.getToolType().includeLooting() ? EIText.ELECTRIC_TOOL_HELP_2_LOOTING : EIText.ELECTRIC_TOOL_HELP_2)).arg((Object)"sneak", KEYBIND_PARSER).arg((Object)"use", KEYBIND_PARSER));
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.ELECTRIC_TOOL_HELP_3).arg((Object)EIText.KEY_ALT.text().withStyle(MITooltips.NUMBER_TEXT)).arg((Object)EIText.KEY_MOUSE_SCROLL.text().withStyle(MITooltips.NUMBER_TEXT)));
        if (item.getToolType().canDo3by3()) {
            lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.ELECTRIC_TOOL_HELP_4).arg((Object)"%s.toggle_main_hand_ability".formatted("extended_industrialization"), KEYBIND_PARSER));
        }
        return lines;
    });
    public static final TooltipAttachment NANO_SUIT_HELP = TooltipAttachment.multilines(NanoSuitArmorItem.class, (stack, item) -> {
        ArrayList lines = Lists.newArrayList();
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.NANO_SUIT_HELP_1));
        lines.add(MICompatibleTextLine.line((TranslatableTextEnum)EIText.DYEABLE_AND_TRIMMABLE_HELP));
        item.ability().ifPresent(ability -> lines.addAll(ability.getHelpTooltipLines((NanoSuitArmorItem)item, stack)));
        return lines;
    });
    public static final TooltipAttachment MACHINE_CHAINER = TooltipAttachment.multilines(List.of(EI.id("machine_chainer")), List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.MACHINE_CHAINER_HELP_1).arg((Object)EIConfig.machineChainerMaxConnections), MICompatibleTextLine.line((TranslatableTextEnum)EIText.MACHINE_CHAINER_HELP_2), MICompatibleTextLine.line((TranslatableTextEnum)EIText.MACHINE_CHAINER_HELP_3)));
    public static final TooltipAttachment HONEY_EXTRACTOR = TooltipAttachment.singleLine(List.of(EI.id("steel_honey_extractor"), EI.id("electric_honey_extractor")), (Component)MICompatibleTextLine.line((TranslatableTextEnum)EIText.HONEY_EXTRACTOR_HELP));
    public static final TooltipAttachment WASTE_COLLECTOR = TooltipAttachment.singleLine(List.of(EI.id("bronze_waste_collector"), EI.id("steel_waste_collector"), EI.id("electric_waste_collector")), (Component)MICompatibleTextLine.line((TranslatableTextEnum)EIText.WASTE_COLLECTOR_HELP));
    public static final TooltipAttachment CHARGING_STATION_RANGED = TooltipAttachment.singleLine(List.of(EI.id("local_wireless_charging_station")), (Component)MICompatibleTextLine.line((TranslatableTextEnum)EIText.CHARGING_STATION_RANGED).arg((Object)EIConfig.localWirelessChargingStationRange));
    public static final TooltipAttachment CHARGING_STATION_GLOBAL = TooltipAttachment.singleLine(List.of(EI.id("global_wireless_charging_station")), (Component)MICompatibleTextLine.line((TranslatableTextEnum)EIText.CHARGING_STATION_GLOBAL));
    public static final TooltipAttachment CHARGING_STATION_INTERDIMENSIONAL = TooltipAttachment.singleLine(List.of(EI.id("interdimensional_wireless_charging_station")), (Component)MICompatibleTextLine.line((TranslatableTextEnum)EIText.CHARGING_STATION_INTERDIMENSIONAL));

    public static void init() {
    }
}

