/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import java.util.Comparator;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.extended_industrialization.EIComponents;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.recipe.RainbowableDyeRecipe;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class EIOtherRegistries {
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"extended_industrialization");
    public static final Supplier<RecipeSerializer<RainbowableDyeRecipe>> RAINBOWABLE_DYE_SERIALIZER = RECIPE_SERIALIZERS.register("crafting_special_rainbowable_dye", () -> new SimpleCraftingRecipeSerializer(RainbowableDyeRecipe::new));
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"extended_industrialization");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"extended_industrialization");
    public static final Supplier<CreativeModeTab> CREATIVE_TAB = CREATIVE_MODE_TABS.register("extended_industrialization", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.%s.%s".formatted("extended_industrialization", "extended_industrialization"))).icon(() -> {
        ItemStack stack = EIItems.ELECTRIC_MINING_DRILL.asItem().getDefaultInstance();
        stack.set(EIComponents.HIDE_BAR, (Object)true);
        return stack;
    }).displayItems((params, output) -> {
        Comparator<ItemHolder> compareBySortOrder = Comparator.comparing(ItemHolder::sortOrder);
        Comparator<ItemHolder> compareByName = Comparator.comparing(i -> i.identifier().id());
        EIItems.values().stream().sorted(compareBySortOrder.thenComparing(compareByName)).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
    }).build());

    public static void init(IEventBus bus) {
        RECIPE_SERIALIZERS.register(bus);
        RECIPE_TYPES.register(bus);
        CREATIVE_MODE_TABS.register(bus);
    }
}

