/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import net.neoforged.neoforge.common.ModConfigSpec;

public final class EIConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.IntValue LOCAL_WIRELESS_CHARGING_STATION_RANGE = BUILDER.comment("The range for the local wireless charging station machine").defineInRange("local_wireless_charging_station_range", 32, 0, Integer.MAX_VALUE);
    private static final ModConfigSpec.IntValue MACHINE_CHAINER_MAX_CONNECTIONS = BUILDER.comment("The maximum amount of connections a machine chainer can have").defineInRange("machine_chainer_max_connections", 64, 1, 128);
    private static final ModConfigSpec.BooleanValue ALLOW_UPGRADES_IN_PROCESSING_ARRAY = BUILDER.comment("Whether upgrades should be allowed in the Processing Array").define("allow_upgrades_in_processing_array", true);
    private static final ModConfigSpec.IntValue LARGE_STEAM_MACERATOR_SIZE;
    private static final ModConfigSpec.DoubleValue LARGE_STEAM_MACERATOR_EU;
    private static final ModConfigSpec.IntValue LARGE_STEAM_FURNACE_SIZE;
    private static final ModConfigSpec.DoubleValue LARGE_STEAM_FURNACE_EU;
    private static final ModConfigSpec.IntValue LARGE_ELECTRIC_MACERATOR_SIZE;
    private static final ModConfigSpec.DoubleValue LARGE_ELECTRIC_MACERATOR_EU;
    private static final ModConfigSpec.DoubleValue PROCESSING_ARRAY_EU;
    public static final ModConfigSpec SPEC;
    public static int localWirelessChargingStationRange;
    public static int machineChainerMaxConnections;
    public static boolean allowUpgradesInProcessingArray;
    public static int largeSteamMaceratorBatchSize;
    public static double largeSteamMaceratorEuCostMultiplier;
    public static int largeSteamFurnaceBatchSize;
    public static double largeSteamFurnaceEuCostMultiplier;
    public static int largeElectricMaceratorBatchSize;
    public static double largeElectricMaceratorEuCostMultiplier;
    public static double processingArrayEuCostMultiplier;

    public static void loadConfig() {
        localWirelessChargingStationRange = (Integer)LOCAL_WIRELESS_CHARGING_STATION_RANGE.get();
        machineChainerMaxConnections = (Integer)MACHINE_CHAINER_MAX_CONNECTIONS.get();
        allowUpgradesInProcessingArray = (Boolean)ALLOW_UPGRADES_IN_PROCESSING_ARRAY.get();
        largeSteamMaceratorBatchSize = (Integer)LARGE_STEAM_MACERATOR_SIZE.get();
        largeSteamMaceratorEuCostMultiplier = (Double)LARGE_STEAM_MACERATOR_EU.get();
        largeSteamFurnaceBatchSize = (Integer)LARGE_STEAM_FURNACE_SIZE.get();
        largeSteamFurnaceEuCostMultiplier = (Double)LARGE_STEAM_FURNACE_EU.get();
        largeElectricMaceratorBatchSize = (Integer)LARGE_ELECTRIC_MACERATOR_SIZE.get();
        largeElectricMaceratorEuCostMultiplier = (Double)LARGE_ELECTRIC_MACERATOR_EU.get();
        processingArrayEuCostMultiplier = (Double)PROCESSING_ARRAY_EU.get();
    }

    static {
        BUILDER.push("batching_machines");
        LARGE_STEAM_MACERATOR_SIZE = BUILDER.comment("The maximum batch size to use for the Large Steam Macerator").defineInRange("large_steam_macerator_size", 8, 1, Integer.MAX_VALUE);
        LARGE_STEAM_MACERATOR_EU = BUILDER.comment("The multiplier to use for the EU cost of the Large Steam Macerator").defineInRange("large_steam_macerator_eu", 0.75, 0.1, Double.MAX_VALUE);
        LARGE_STEAM_FURNACE_SIZE = BUILDER.comment("The maximum batch size to use for the Large Steam Furnace").defineInRange("large_steam_furnace_size", 8, 1, Integer.MAX_VALUE);
        LARGE_STEAM_FURNACE_EU = BUILDER.comment("The multiplier to use for the EU cost of the Large Steam Furnace").defineInRange("large_steam_furnace_eu", 0.75, 0.1, Double.MAX_VALUE);
        LARGE_ELECTRIC_MACERATOR_SIZE = BUILDER.comment("The maximum batch size to use for the Large Electric Macerator").defineInRange("large_electric_macerator_size", 16, 1, Integer.MAX_VALUE);
        LARGE_ELECTRIC_MACERATOR_EU = BUILDER.comment("The multiplier to use for the EU cost of the Large Electric Macerator").defineInRange("large_electric_macerator_eu", 0.75, 0.1, Double.MAX_VALUE);
        PROCESSING_ARRAY_EU = BUILDER.comment("The multiplier to use for the EU cost of the Processing Array").defineInRange("processing_array_eu", 1.0, 0.1, Double.MAX_VALUE);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

