/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineBlockEntityRenderer;
import aztech.modern_industrialization.machines.blockentities.multiblocks.LargeTankMultiblockBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBER;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockTankBER;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIBlocks;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EIKeybinds;
import net.swedz.extended_industrialization.client.MachineChainerHighlightRenderer;
import net.swedz.extended_industrialization.client.NanoGravichestplateHudRenderer;
import net.swedz.extended_industrialization.item.ElectricToolItem;
import net.swedz.extended_industrialization.item.SteamChainsawItem;
import net.swedz.extended_industrialization.item.machineconfig.MachineConfigCardItem;
import net.swedz.extended_industrialization.item.tooltip.MachineConfigCardTooltipComponent;
import net.swedz.extended_industrialization.item.tooltip.SteamChainsawTooltipComponent;
import net.swedz.extended_industrialization.machines.blockentity.MachineChainerMachineBlockEntity;
import net.swedz.extended_industrialization.network.packet.ModifyElectricToolSpeedPacket;
import net.swedz.tesseract.neoforge.item.DynamicDyedItem;

@Mod(value="extended_industrialization", dist={Dist.CLIENT})
@EventBusSubscriber(value={Dist.CLIENT}, modid="extended_industrialization", bus=EventBusSubscriber.Bus.MOD)
public final class EIClient {
    public EIClient(IEventBus bus) {
        EIKeybinds.init(bus);
        NeoForge.EVENT_BUS.addListener(ClientTickEvent.Post.class, event -> {
            for (EIKeybinds.Keybind keybind : EIKeybinds.Registry.getMappings()) {
                while (((KeyMapping)keybind.holder().get()).consumeClick()) {
                    keybind.action().run();
                }
            }
        });
        NeoForge.EVENT_BUS.addListener(InputEvent.MouseScrollingEvent.class, event -> {
            LocalPlayer player;
            ItemStack stack;
            if (Screen.hasAltDown() && (stack = (player = Minecraft.getInstance().player).getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof ElectricToolItem) {
                boolean increase = event.getScrollDeltaY() > 0.0;
                int speed = ElectricToolItem.getToolSpeed(stack);
                if (increase ? speed < 10 : speed > 1) {
                    new ModifyElectricToolSpeedPacket(increase).sendToServer();
                }
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    private static void onRegisterColorItems(RegisterColorHandlersEvent.Item event) {
        event.register((stack, color) -> color > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)((DynamicDyedItem)stack.getItem()).getDefaultDyeColor()), new ItemLike[]{EIItems.ULTIMATE_LASER_DRILL, EIItems.NANO_HELMET, EIItems.NANO_CHESTPLATE, EIItems.NANO_GRAVICHESTPLATE, EIItems.NANO_LEGGINGS, EIItems.NANO_BOOTS});
    }

    @SubscribeEvent
    private static void registerBlockEntityRenderers(FMLClientSetupEvent event) {
        for (DeferredHolder blockDef : EIBlocks.Registry.BLOCKS.getEntries()) {
            Object object = blockDef.get();
            if (!(object instanceof MachineBlock)) continue;
            MachineBlock machine = (MachineBlock)object;
            MachineBlockEntity blockEntity = machine.getBlockEntityInstance();
            BlockEntityType type = blockEntity.getType();
            if (blockEntity instanceof LargeTankMultiblockBlockEntity) {
                BlockEntityRenderers.register((BlockEntityType)type, MultiblockTankBER::new);
                continue;
            }
            if (blockEntity instanceof MultiblockMachineBlockEntity) {
                BlockEntityRenderers.register((BlockEntityType)type, MultiblockMachineBER::new);
                continue;
            }
            if (blockEntity instanceof MachineChainerMachineBlockEntity) {
                BlockEntityRenderers.register((BlockEntityType)type, MachineChainerHighlightRenderer::new);
                continue;
            }
            BlockEntityRenderers.register((BlockEntityType)type, c -> new MachineBlockEntityRenderer(c));
        }
    }

    @SubscribeEvent
    private static void registerClientTooltipComponents(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(SteamChainsawItem.SteamChainsawTooltipData.class, SteamChainsawTooltipComponent::new);
        event.register(MachineConfigCardItem.TooltipData.class, MachineConfigCardTooltipComponent::new);
    }

    @SubscribeEvent
    private static void registerGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.SELECTED_ITEM_NAME, EI.id("nano_gravichestplate_activation_status"), NanoGravichestplateHudRenderer::render);
    }
}

