/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import aztech.modern_industrialization.util.TagHelper;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EISortOrder;
import net.swedz.extended_industrialization.EITags;
import net.swedz.tesseract.neoforge.registry.SortOrder;
import net.swedz.tesseract.neoforge.registry.common.CommonLootTableBuilders;
import net.swedz.tesseract.neoforge.registry.common.CommonModelBuilders;
import net.swedz.tesseract.neoforge.registry.holder.BlockHolder;
import net.swedz.tesseract.neoforge.registry.holder.BlockWithItemHolder;

public final class EIBlocks {
    public static final BlockHolder<Block> MACHINE_CHAINER_RELAY = ((BlockHolder)((BlockHolder)((BlockHolder)EIBlocks.create("machine_chainer_relay", "Machine Chainer Relay", Block::new, BlockItem::new, EISortOrder.MACHINES).withProperties(p -> p.mapColor(MapColor.METAL).destroyTime(4.0f).requiresCorrectToolForDrops()).tag(TagHelper.getMiningLevelTag((int)1))).tag(new TagKey[]{EITags.Blocks.MACHINE_CHAINER_RELAY})).withLootTable(CommonLootTableBuilders::self).withModel(CommonModelBuilders::blockstateOnly)).register();
    public static final BlockHolder<Block> STEEL_PLATED_BRICKS = ((BlockHolder)((BlockHolder)EIBlocks.create("steel_plated_bricks", "Steel Plated Bricks", Block::new, BlockItem::new, EISortOrder.CASINGS).withProperties(p -> p.destroyTime(5.0f).explosionResistance(6.0f).requiresCorrectToolForDrops()).tag(TagHelper.getMiningLevelTag((int)1))).withLootTable(CommonLootTableBuilders::self).withModel(CommonModelBuilders::blockCubeAll)).register();

    public static void init(IEventBus bus) {
        Registry.init(bus);
    }

    public static Set<BlockHolder> values() {
        return Set.copyOf(Registry.HOLDERS);
    }

    public static Block get(String id) {
        return Registry.HOLDERS.stream().filter(b -> b.identifier().id().equals(id)).findFirst().orElseThrow().get();
    }

    public static <BlockType extends Block> BlockHolder<BlockType> create(String id, String englishName, Function<BlockBehaviour.Properties, BlockType> blockCreator) {
        BlockHolder holder = new BlockHolder(EI.id(id), englishName, Registry.BLOCKS, blockCreator);
        Registry.include(holder);
        return holder;
    }

    public static <BlockType extends Block, ItemType extends BlockItem> BlockWithItemHolder<BlockType, ItemType> create(String id, String englishName, Function<BlockBehaviour.Properties, BlockType> blockCreator, BiFunction<Block, Item.Properties, ItemType> itemCreator, SortOrder sortOrder) {
        BlockWithItemHolder holder = new BlockWithItemHolder(EI.id(id), englishName, Registry.BLOCKS, blockCreator, EIItems.Registry.ITEMS, itemCreator);
        holder.item().sorted(sortOrder);
        Registry.include((BlockHolder)holder);
        EIItems.Registry.include(holder.item());
        return holder;
    }

    public static final class Registry {
        public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"extended_industrialization");
        public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"extended_industrialization");
        private static final Set<BlockHolder> HOLDERS = Sets.newHashSet();

        private static void init(IEventBus bus) {
            BLOCKS.register(bus);
            BLOCK_ENTITIES.register(bus);
        }

        public static void include(BlockHolder holder) {
            HOLDERS.add(holder);
        }
    }
}

