/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.tesseract.neoforge.helper.ColorHelper;

public final class EIArmorMaterials {
    private static final DeferredRegister<ArmorMaterial> MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"extended_industrialization");
    public static final Holder<ArmorMaterial> NANO = EIArmorMaterials.createNanoMaterial("nano");
    public static final Holder<ArmorMaterial> NANO_GRAVICHESTPLATE = EIArmorMaterials.createNanoMaterial("nano_gravichestplate");
    public static final int NANO_COLOR = ColorHelper.getVibrantColor((DyeColor)DyeColor.LIME);
    public static final int NANO_GRAVICHESTPLATE_COLOR = ColorHelper.getVibrantColor((DyeColor)DyeColor.LIGHT_BLUE);

    public static void init(IEventBus bus) {
        MATERIALS.register(bus);
    }

    private static Holder<ArmorMaterial> create(String name, Function<ResourceLocation, ArmorMaterial> creator) {
        return MATERIALS.register(name, creator);
    }

    private static Holder<ArmorMaterial> createNanoMaterial(String name) {
        return EIArmorMaterials.create(name, id -> new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            for (ArmorItem.Type type : ArmorItem.Type.values()) {
                map.put(type, 6);
            }
        }), 0, SoundEvents.ARMOR_EQUIP_NETHERITE, () -> {
            throw new UnsupportedOperationException("Cannot repair nano armor");
        }, List.of(new ArmorMaterial.Layer(id, "", true), new ArmorMaterial.Layer(id, "_overlay", false)), 3.0f, 0.1f));
    }
}

