/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.immediate;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ColorVertex;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;

public class CloudRenderer {
    private static final ResourceLocation CLOUDS_TEXTURE_ID = ResourceLocation.withDefaultNamespace((String)"textures/environment/clouds.png");
    private CloudTextureData textureData;
    private ShaderInstance shaderProgram;
    @Nullable
    private CloudGeometry cachedGeometry;
    private static final Vector3f[][] VERTICES = new Vector3f[CloudFace.COUNT][];

    public CloudRenderer(ResourceProvider resourceProvider) {
        this.reloadTextures(resourceProvider);
    }

    public void render(Camera camera, ClientLevel level, Matrix4f projectionMatrix, PoseStack poseStack, float ticks, float tickDelta) {
        VertexBuffer vertexBuffer;
        float cloudHeight = level.effects().getCloudHeight();
        if (Float.isNaN(cloudHeight)) {
            return;
        }
        if (this.textureData.isBlank) {
            return;
        }
        Vec3 pos = camera.getPosition();
        double cloudTime = (ticks + tickDelta) * 0.03f;
        double cloudCenterX = pos.x() + cloudTime;
        double cloudCenterZ = pos.z() + 0.33;
        int cloudDistance = CloudRenderer.getCloudRenderDistance();
        int centerCellX = (int)Math.floor(cloudCenterX / 12.0);
        int centerCellZ = (int)Math.floor(cloudCenterZ / 12.0);
        CloudStatus cloudType = Minecraft.getInstance().options.getCloudsType();
        int orientation = cloudType == CloudStatus.FANCY ? (int)Math.signum(pos.y() - (double)cloudHeight) : 0;
        CloudGeometryParameters parameters = new CloudGeometryParameters(centerCellX, centerCellZ, cloudDistance, orientation, cloudType);
        CloudGeometry geometry = this.cachedGeometry;
        if (geometry == null || !Objects.equals(geometry.params(), parameters)) {
            this.cachedGeometry = geometry = CloudRenderer.rebuildGeometry(geometry, parameters, this.textureData);
        }
        if ((vertexBuffer = geometry.vertexBuffer()) == null) {
            return;
        }
        float translateX = (float)(cloudCenterX - (double)(centerCellX * 12));
        float translateZ = (float)(cloudCenterZ - (double)(centerCellZ * 12));
        poseStack.pushPose();
        PoseStack.Pose poseEntry = poseStack.last();
        Matrix4f modelViewMatrix = poseEntry.pose();
        modelViewMatrix.translate(-translateX, cloudHeight - (float)pos.y() + 0.33f, -translateZ);
        FogShape prevShaderFogShape = RenderSystem.getShaderFogShape();
        float prevShaderFogEnd = RenderSystem.getShaderFogEnd();
        float prevShaderFogStart = RenderSystem.getShaderFogStart();
        FogRenderer.setupFog((Camera)camera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (float)(cloudDistance * 8), (boolean)CloudRenderer.shouldUseWorldFog(level, pos), (float)tickDelta);
        boolean fastClouds = geometry.params().renderMode() == CloudStatus.FAST;
        boolean fabulous = Minecraft.useShaderTransparency();
        if (fastClouds) {
            RenderSystem.disableCull();
        }
        if (fabulous) {
            Minecraft.getInstance().levelRenderer.getCloudsTarget().bindWrite(false);
        }
        Vec3 colorModulator = level.getCloudColor(tickDelta);
        RenderSystem.setShaderColor((float)((float)colorModulator.x), (float)((float)colorModulator.y), (float)((float)colorModulator.z), (float)0.8f);
        vertexBuffer.bind();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthFunc((int)513);
        vertexBuffer.drawWithShader(modelViewMatrix, projectionMatrix, this.shaderProgram);
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableBlend();
        VertexBuffer.unbind();
        if (fastClouds) {
            RenderSystem.enableCull();
        }
        if (fabulous) {
            Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderFogShape((FogShape)prevShaderFogShape);
        RenderSystem.setShaderFogEnd((float)prevShaderFogEnd);
        RenderSystem.setShaderFogStart((float)prevShaderFogStart);
        poseStack.popPose();
    }

    @NotNull
    private static CloudGeometry rebuildGeometry(@Nullable CloudGeometry existingGeometry, CloudGeometryParameters parameters, CloudTextureData textureData) {
        int layer;
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)bufferBuilder);
        int originCellX = parameters.originX();
        int originCellZ = parameters.originZ();
        int orientation = parameters.orientation();
        int radius = parameters.radius();
        boolean useFastGraphics = parameters.renderMode() == CloudStatus.FAST;
        CloudRenderer.addCellGeometryToBuffer(writer, textureData, originCellX, originCellZ, 0, 0, orientation, useFastGraphics);
        for (layer = 1; layer <= radius; ++layer) {
            int x;
            int z;
            for (z = -layer; z < layer; ++z) {
                x = Math.abs(z) - layer;
                CloudRenderer.addCellGeometryToBuffer(writer, textureData, originCellX, originCellZ, x, z, orientation, useFastGraphics);
            }
            for (z = layer; z > -layer; --z) {
                x = layer - Math.abs(z);
                CloudRenderer.addCellGeometryToBuffer(writer, textureData, originCellX, originCellZ, x, z, orientation, useFastGraphics);
            }
        }
        for (layer = radius + 1; layer <= 2 * radius; ++layer) {
            int x;
            int z;
            int l = layer - radius;
            for (z = -radius; z <= -l; ++z) {
                x = -z - layer;
                CloudRenderer.addCellGeometryToBuffer(writer, textureData, originCellX, originCellZ, x, z, orientation, useFastGraphics);
            }
            for (z = l; z <= radius; ++z) {
                x = z - layer;
                CloudRenderer.addCellGeometryToBuffer(writer, textureData, originCellX, originCellZ, x, z, orientation, useFastGraphics);
            }
            for (z = radius; z >= l; --z) {
                x = layer - z;
                CloudRenderer.addCellGeometryToBuffer(writer, textureData, originCellX, originCellZ, x, z, orientation, useFastGraphics);
            }
            for (z = -l; z >= -radius; --z) {
                x = layer + z;
                CloudRenderer.addCellGeometryToBuffer(writer, textureData, originCellX, originCellZ, x, z, orientation, useFastGraphics);
            }
        }
        MeshData builtBuffer = bufferBuilder.build();
        VertexBuffer vertexBuffer = null;
        if (builtBuffer != null) {
            if (existingGeometry != null) {
                vertexBuffer = existingGeometry.vertexBuffer();
            }
            if (vertexBuffer == null) {
                vertexBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
            }
            CloudRenderer.uploadToVertexBuffer(vertexBuffer, builtBuffer);
        }
        Tesselator.getInstance().clear();
        return new CloudGeometry(vertexBuffer, parameters);
    }

    private static void addCellGeometryToBuffer(VertexBufferWriter writer, CloudTextureData textureData, int originX, int originZ, int offsetX, int offsetZ, int orientation, boolean useFastGraphics) {
        int cellX = originX + offsetX;
        int cellZ = originZ + offsetZ;
        int cellIndex = textureData.getCellIndexWrapping(cellX, cellZ);
        int cellFaces = textureData.getCellFaces(cellIndex) & CloudRenderer.getVisibleFaces(offsetX, offsetZ, orientation);
        if (cellFaces == 0) {
            return;
        }
        int cellColor = textureData.getCellColor(cellIndex);
        if (ColorABGR.unpackAlpha(cellColor) == 0) {
            return;
        }
        float x = offsetX * 12;
        float z = offsetZ * 12;
        if (useFastGraphics) {
            CloudRenderer.emitCellGeometry2D(writer, cellFaces, cellColor, x, z);
        } else {
            CloudRenderer.emitCellGeometry3D(writer, cellFaces, cellColor, x, z, false);
            int distance = Math.abs(offsetX) + Math.abs(offsetZ);
            if (distance <= 1) {
                CloudRenderer.emitCellGeometry3D(writer, CloudFaceSet.all(), cellColor, x, z, true);
            }
        }
    }

    private static int getVisibleFaces(int x, int z, int orientation) {
        int faces = CloudFaceSet.all();
        if (x > 0) {
            faces = CloudFaceSet.remove(faces, CloudFace.POS_X);
        }
        if (z > 0) {
            faces = CloudFaceSet.remove(faces, CloudFace.POS_Z);
        }
        if (x < 0) {
            faces = CloudFaceSet.remove(faces, CloudFace.NEG_X);
        }
        if (z < 0) {
            faces = CloudFaceSet.remove(faces, CloudFace.NEG_Z);
        }
        if (orientation < 0) {
            faces = CloudFaceSet.remove(faces, CloudFace.POS_Y);
        }
        if (orientation > 0) {
            faces = CloudFaceSet.remove(faces, CloudFace.NEG_Y);
        }
        return faces;
    }

    private static void emitCellGeometry2D(VertexBufferWriter writer, int faces, int color, float x, float z) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(64);
            int count = 0;
            int mixedColor = ColorMixer.mul(color, CloudFace.POS_Y.getColor());
            ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 0.0f, z + 12.0f, mixedColor);
            ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 12.0f, mixedColor);
            ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 0.0f, mixedColor);
            ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 0.0f, z + 0.0f, mixedColor);
            writer.push(stack, buffer, count += 4, ColorVertex.FORMAT);
        }
    }

    private static void emitCellGeometry3D(VertexBufferWriter writer, int visibleFaces, int baseColor, float posX, float posZ, boolean interior) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(384);
            int count = 0;
            for (CloudFace face : CloudFace.VALUES) {
                if (!CloudFaceSet.contains(visibleFaces, face)) continue;
                Vector3f[] vertices = VERTICES[face.ordinal()];
                int color = ColorMixer.mul(baseColor, face.getColor());
                for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                    Vector3f vertex = vertices[interior ? 3 - vertexIndex : vertexIndex];
                    float x = vertex.x + posX;
                    float y = vertex.y;
                    float z = vertex.z + posZ;
                    ptr = CloudRenderer.writeVertex(ptr, x, y, z, color);
                }
                count += 4;
            }
            if (count > 0) {
                writer.push(stack, buffer, count, ColorVertex.FORMAT);
            }
        }
    }

    private static long writeVertex(long buffer, float x, float y, float z, int color) {
        ColorVertex.put(buffer, x, y, z, color);
        return buffer + 16L;
    }

    private static void uploadToVertexBuffer(VertexBuffer vertexBuffer, MeshData builtBuffer) {
        vertexBuffer.bind();
        vertexBuffer.upload(builtBuffer);
        VertexBuffer.unbind();
    }

    public void reloadTextures(ResourceProvider resourceProvider) {
        this.destroy();
        this.textureData = CloudRenderer.loadTextureData();
        try {
            this.shaderProgram = new ShaderInstance(resourceProvider, "clouds", DefaultVertexFormat.POSITION_COLOR);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        if (this.shaderProgram != null) {
            this.shaderProgram.close();
            this.shaderProgram = null;
        }
        if (this.cachedGeometry != null) {
            VertexBuffer vertexBuffer = this.cachedGeometry.vertexBuffer();
            vertexBuffer.close();
            this.cachedGeometry = null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static CloudTextureData loadTextureData() {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        Resource resource = (Resource)resourceManager.getResource(CLOUDS_TEXTURE_ID).orElseThrow();
        try (InputStream inputStream = resource.open();){
            CloudTextureData cloudTextureData;
            block14: {
                NativeImage nativeImage = NativeImage.read((InputStream)inputStream);
                try {
                    cloudTextureData = new CloudTextureData(nativeImage);
                    if (nativeImage == null) break block14;
                }
                catch (Throwable throwable) {
                    if (nativeImage != null) {
                        try {
                            nativeImage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                nativeImage.close();
            }
            return cloudTextureData;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load texture data", ex);
        }
    }

    private static boolean shouldUseWorldFog(ClientLevel level, Vec3 pos) {
        return level.effects().isFoggyAt(Mth.floor((double)pos.x()), Mth.floor((double)pos.z())) || Minecraft.getInstance().gui.getBossOverlay().shouldCreateWorldFog();
    }

    private static int getCloudRenderDistance() {
        return Math.max(32, Minecraft.getInstance().options.getEffectiveRenderDistance() * 2 + 9);
    }

    private static boolean isTransparentCell(int color) {
        return ColorARGB.unpackAlpha(color) <= 1;
    }

    static {
        CloudRenderer.VERTICES[CloudFace.NEG_Y.ordinal()] = new Vector3f[]{new Vector3f(12.0f, 0.0f, 12.0f), new Vector3f(0.0f, 0.0f, 12.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(12.0f, 0.0f, 0.0f)};
        CloudRenderer.VERTICES[CloudFace.POS_Y.ordinal()] = new Vector3f[]{new Vector3f(0.0f, 4.0f, 12.0f), new Vector3f(12.0f, 4.0f, 12.0f), new Vector3f(12.0f, 4.0f, 0.0f), new Vector3f(0.0f, 4.0f, 0.0f)};
        CloudRenderer.VERTICES[CloudFace.NEG_X.ordinal()] = new Vector3f[]{new Vector3f(0.0f, 0.0f, 12.0f), new Vector3f(0.0f, 4.0f, 12.0f), new Vector3f(0.0f, 4.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)};
        CloudRenderer.VERTICES[CloudFace.POS_X.ordinal()] = new Vector3f[]{new Vector3f(12.0f, 4.0f, 12.0f), new Vector3f(12.0f, 0.0f, 12.0f), new Vector3f(12.0f, 0.0f, 0.0f), new Vector3f(12.0f, 4.0f, 0.0f)};
        CloudRenderer.VERTICES[CloudFace.NEG_Z.ordinal()] = new Vector3f[]{new Vector3f(12.0f, 4.0f, 0.0f), new Vector3f(12.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 4.0f, 0.0f)};
        CloudRenderer.VERTICES[CloudFace.POS_Z.ordinal()] = new Vector3f[]{new Vector3f(12.0f, 0.0f, 12.0f), new Vector3f(12.0f, 4.0f, 12.0f), new Vector3f(0.0f, 4.0f, 12.0f), new Vector3f(0.0f, 0.0f, 12.0f)};
    }

    private static class CloudTextureData {
        private final byte[] faces;
        private final int[] colors;
        private boolean isBlank;
        private final int width;
        private final int height;

        public CloudTextureData(NativeImage texture) {
            int width = texture.getWidth();
            int height = texture.getHeight();
            this.faces = new byte[width * height];
            this.colors = new int[width * height];
            this.isBlank = true;
            this.width = width;
            this.height = height;
            this.loadTextureData(texture, width, height);
        }

        private void loadTextureData(NativeImage texture, int width, int height) {
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < height; ++z) {
                    int color;
                    int index = this.getCellIndex(x, z);
                    this.colors[index] = color = texture.getPixelRGBA(x, z);
                    if (CloudRenderer.isTransparentCell(color)) continue;
                    this.faces[index] = (byte)CloudTextureData.getOpenFaces(texture, color, x, z);
                    this.isBlank = false;
                }
            }
        }

        private static int getOpenFaces(NativeImage image, int color, int x, int z) {
            int faces = CloudFaceSet.empty();
            faces = CloudFaceSet.add(faces, CloudFace.NEG_Y);
            faces = CloudFaceSet.add(faces, CloudFace.POS_Y);
            int neighbor = CloudTextureData.getNeighborTexel(image, x - 1, z);
            if (color != neighbor) {
                faces = CloudFaceSet.add(faces, CloudFace.NEG_X);
            }
            if (color != (neighbor = CloudTextureData.getNeighborTexel(image, x + 1, z))) {
                faces = CloudFaceSet.add(faces, CloudFace.POS_X);
            }
            if (color != (neighbor = CloudTextureData.getNeighborTexel(image, x, z - 1))) {
                faces = CloudFaceSet.add(faces, CloudFace.NEG_Z);
            }
            if (color != (neighbor = CloudTextureData.getNeighborTexel(image, x, z + 1))) {
                faces = CloudFaceSet.add(faces, CloudFace.POS_Z);
            }
            return faces;
        }

        private static int getNeighborTexel(NativeImage image, int x, int z) {
            x = CloudTextureData.wrapTexelCoord(x, 0, image.getWidth() - 1);
            z = CloudTextureData.wrapTexelCoord(z, 0, image.getHeight() - 1);
            return image.getPixelRGBA(x, z);
        }

        private static int wrapTexelCoord(int coord, int min, int max) {
            if (coord < min) {
                coord = max;
            }
            if (coord > max) {
                coord = min;
            }
            return coord;
        }

        public int getCellFaces(int index) {
            return this.faces[index];
        }

        public int getCellColor(int index) {
            return this.colors[index];
        }

        private int getCellIndexWrapping(int x, int z) {
            return this.getCellIndex(Math.floorMod(x, this.width), Math.floorMod(z, this.height));
        }

        private int getCellIndex(int x, int z) {
            return x * this.width + z;
        }
    }

    public record CloudGeometryParameters(int originX, int originZ, int radius, int orientation, CloudStatus renderMode) {
    }

    public record CloudGeometry(VertexBuffer vertexBuffer, CloudGeometryParameters params) {
    }

    private static class CloudFaceSet {
        private CloudFaceSet() {
        }

        public static int empty() {
            return 0;
        }

        public static boolean contains(int set, CloudFace face) {
            return (set & 1 << face.ordinal()) != 0;
        }

        public static int add(int set, CloudFace face) {
            return set | 1 << face.ordinal();
        }

        public static int remove(int set, CloudFace face) {
            return set & ~(1 << face.ordinal());
        }

        public static int all() {
            return (1 << CloudFace.COUNT) - 1;
        }
    }

    private static enum CloudFace {
        NEG_Y(ColorABGR.pack(0.7f, 0.7f, 0.7f, 1.0f)),
        POS_Y(ColorABGR.pack(1.0f, 1.0f, 1.0f, 1.0f)),
        NEG_X(ColorABGR.pack(0.9f, 0.9f, 0.9f, 1.0f)),
        POS_X(ColorABGR.pack(0.9f, 0.9f, 0.9f, 1.0f)),
        NEG_Z(ColorABGR.pack(0.8f, 0.8f, 0.8f, 1.0f)),
        POS_Z(ColorABGR.pack(0.8f, 0.8f, 0.8f, 1.0f));

        public static final CloudFace[] VALUES;
        public static final int COUNT;
        private final int color;

        private CloudFace(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }

        static {
            VALUES = CloudFace.values();
            COUNT = VALUES.length;
        }
    }
}

