/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.MatrixUtil;
import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.client.render.frapi.helper.ColorHelper;
import net.caffeinemc.mods.sodium.client.render.frapi.material.RenderMaterialImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.EncodingFormat;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.render.AbstractRenderContext;
import net.caffeinemc.mods.sodium.client.render.frapi.render.QuadEncoder;
import net.caffeinemc.mods.sodium.client.render.texture.SpriteFinderCache;
import net.caffeinemc.mods.sodium.client.render.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.mixin.features.render.frapi.ItemRendererAccessor;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.fabric.impl.renderer.VanillaModelEncoder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ItemRenderContext
extends AbstractRenderContext {
    private static final long ITEM_RANDOM_SEED = 42L;
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            ItemRenderContext.this.renderQuad(this);
        }
    };
    @Deprecated
    private final BakedModelConsumerImpl vanillaModelConsumer = new BakedModelConsumerImpl();
    private final ItemColors colorMap;
    private final VanillaModelBufferer vanillaBufferer;
    private final RandomSource random = new SingleThreadedRandomSource(42L);
    private final Supplier<RandomSource> randomSupplier = () -> {
        this.random.setSeed(42L);
        return this.random;
    };
    private ItemStack itemStack;
    private ItemDisplayContext transformMode;
    private PoseStack poseStack;
    private Matrix4f matPosition;
    private boolean trustedNormals;
    private Matrix3f matNormal;
    private MultiBufferSource bufferSource;
    private int lightmap;
    private int overlay;
    private boolean isDefaultTranslucent;
    private boolean isTranslucentDirect;
    private boolean isDefaultGlint;
    private boolean isGlintDynamicDisplay;
    private PoseStack.Pose dynamicDisplayGlintEntry;
    private VertexConsumer translucentVertexConsumer;
    private VertexConsumer cutoutVertexConsumer;
    private VertexConsumer translucentGlintVertexConsumer;
    private VertexConsumer cutoutGlintVertexConsumer;
    private VertexConsumer defaultVertexConsumer;

    public ItemRenderContext(ItemColors colorMap, VanillaModelBufferer vanillaBufferer) {
        this.colorMap = colorMap;
        this.vanillaBufferer = vanillaBufferer;
    }

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    public boolean isFaceCulled(@Nullable Direction face) {
        throw new UnsupportedOperationException("isFaceCulled can only be called on a block render context.");
    }

    public ItemDisplayContext itemTransformationMode() {
        return this.transformMode;
    }

    @Deprecated
    public RenderContext.BakedModelConsumer bakedModelConsumer() {
        return this.vanillaModelConsumer;
    }

    public void renderModel(ItemStack itemStack, ItemDisplayContext transformMode, boolean invert, PoseStack poseStack, MultiBufferSource bufferSource, int lightmap, int overlay, BakedModel model) {
        this.itemStack = itemStack;
        this.transformMode = transformMode;
        this.poseStack = poseStack;
        this.matPosition = poseStack.last().pose();
        this.trustedNormals = poseStack.last().trustedNormals;
        this.matNormal = poseStack.last().normal();
        this.bufferSource = bufferSource;
        this.lightmap = lightmap;
        this.overlay = overlay;
        this.computeOutputInfo();
        ((FabricBakedModel)model).emitItemQuads(itemStack, this.randomSupplier, (RenderContext)this);
        this.itemStack = null;
        this.poseStack = null;
        this.bufferSource = null;
        this.dynamicDisplayGlintEntry = null;
        this.translucentVertexConsumer = null;
        this.cutoutVertexConsumer = null;
        this.translucentGlintVertexConsumer = null;
        this.cutoutGlintVertexConsumer = null;
        this.defaultVertexConsumer = null;
    }

    private void computeOutputInfo() {
        this.isDefaultTranslucent = true;
        this.isTranslucentDirect = true;
        Item item = this.itemStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockState state = blockItem.getBlock().defaultBlockState();
            RenderType renderType = ItemBlockRenderTypes.getChunkRenderType((BlockState)state);
            if (renderType != RenderType.translucent()) {
                this.isDefaultTranslucent = false;
            }
            if (this.transformMode != ItemDisplayContext.GUI && !this.transformMode.firstPerson()) {
                this.isTranslucentDirect = false;
            }
        }
        this.isDefaultGlint = this.itemStack.hasFoil();
        this.isGlintDynamicDisplay = ItemRendererAccessor.sodium$hasAnimatedTexture(this.itemStack);
        this.defaultVertexConsumer = this.getVertexConsumer(BlendMode.DEFAULT, TriState.DEFAULT);
    }

    private void renderQuad(MutableQuadViewImpl quad) {
        if (!this.transform((MutableQuadView)quad)) {
            return;
        }
        RenderMaterialImpl mat = quad.material();
        int colorIndex = mat.disableColorIndex() ? -1 : quad.colorIndex();
        boolean emissive = mat.emissive();
        VertexConsumer vertexConsumer = this.getVertexConsumer(mat.blendMode(), mat.glint());
        this.colorizeQuad(quad, colorIndex);
        this.shadeQuad(quad, emissive);
        this.bufferQuad(quad, vertexConsumer);
    }

    private void colorizeQuad(MutableQuadViewImpl quad, int colorIndex) {
        if (colorIndex != -1) {
            int itemColor = this.colorMap.getColor(this.itemStack, colorIndex);
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyColor(itemColor, quad.color(i)));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            int lightmap = this.lightmap;
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), lightmap));
            }
        }
    }

    private void bufferQuad(MutableQuadViewImpl quad, VertexConsumer vertexConsumer) {
        QuadEncoder.writeQuadVertices(quad, vertexConsumer, this.overlay, this.matPosition, this.trustedNormals, this.matNormal);
        SpriteUtil.markSpriteActive(quad.sprite(SpriteFinderCache.forBlockAtlas()));
    }

    private VertexConsumer getVertexConsumer(BlendMode blendMode, TriState glintMode) {
        boolean glint;
        boolean translucent;
        if (blendMode == BlendMode.DEFAULT) {
            translucent = this.isDefaultTranslucent;
        } else {
            boolean bl = translucent = blendMode == BlendMode.TRANSLUCENT;
        }
        if (glintMode == TriState.DEFAULT) {
            glint = this.isDefaultGlint;
        } else {
            boolean bl = glint = glintMode == TriState.TRUE;
        }
        if (translucent) {
            if (glint) {
                if (this.translucentGlintVertexConsumer == null) {
                    this.translucentGlintVertexConsumer = this.createTranslucentVertexConsumer(true);
                }
                return this.translucentGlintVertexConsumer;
            }
            if (this.translucentVertexConsumer == null) {
                this.translucentVertexConsumer = this.createTranslucentVertexConsumer(false);
            }
            return this.translucentVertexConsumer;
        }
        if (glint) {
            if (this.cutoutGlintVertexConsumer == null) {
                this.cutoutGlintVertexConsumer = this.createCutoutVertexConsumer(true);
            }
            return this.cutoutGlintVertexConsumer;
        }
        if (this.cutoutVertexConsumer == null) {
            this.cutoutVertexConsumer = this.createCutoutVertexConsumer(false);
        }
        return this.cutoutVertexConsumer;
    }

    private VertexConsumer createTranslucentVertexConsumer(boolean glint) {
        if (glint && this.isGlintDynamicDisplay) {
            return this.createDynamicDisplayGlintVertexConsumer(Minecraft.useShaderTransparency() && !this.isTranslucentDirect ? Sheets.translucentItemSheet() : Sheets.translucentCullBlockSheet());
        }
        if (this.isTranslucentDirect) {
            return ItemRenderer.getFoilBufferDirect((MultiBufferSource)this.bufferSource, (RenderType)Sheets.translucentCullBlockSheet(), (boolean)true, (boolean)glint);
        }
        if (Minecraft.useShaderTransparency()) {
            return ItemRenderer.getFoilBuffer((MultiBufferSource)this.bufferSource, (RenderType)Sheets.translucentItemSheet(), (boolean)true, (boolean)glint);
        }
        return ItemRenderer.getFoilBuffer((MultiBufferSource)this.bufferSource, (RenderType)Sheets.translucentItemSheet(), (boolean)true, (boolean)glint);
    }

    private VertexConsumer createCutoutVertexConsumer(boolean glint) {
        if (glint && this.isGlintDynamicDisplay) {
            return this.createDynamicDisplayGlintVertexConsumer(Sheets.cutoutBlockSheet());
        }
        return ItemRenderer.getFoilBufferDirect((MultiBufferSource)this.bufferSource, (RenderType)Sheets.cutoutBlockSheet(), (boolean)true, (boolean)glint);
    }

    private VertexConsumer createDynamicDisplayGlintVertexConsumer(RenderType type) {
        if (this.dynamicDisplayGlintEntry == null) {
            this.dynamicDisplayGlintEntry = this.poseStack.last().copy();
            if (this.transformMode == ItemDisplayContext.GUI) {
                MatrixUtil.mulComponentWise((Matrix4f)this.dynamicDisplayGlintEntry.pose(), (float)0.5f);
            } else if (this.transformMode.firstPerson()) {
                MatrixUtil.mulComponentWise((Matrix4f)this.dynamicDisplayGlintEntry.pose(), (float)0.75f);
            }
        }
        return ItemRenderer.getCompassFoilBuffer((MultiBufferSource)this.bufferSource, (RenderType)type, (PoseStack.Pose)this.dynamicDisplayGlintEntry);
    }

    public void bufferDefaultModel(BakedModel model, @Nullable BlockState state) {
        if (this.hasTransform() || this.vanillaBufferer == null) {
            VanillaModelEncoder.emitItemQuads((BakedModel)model, (BlockState)state, this.randomSupplier, (RenderContext)this);
        } else {
            this.vanillaBufferer.accept(model, this.itemStack, this.lightmap, this.overlay, this.poseStack, this.defaultVertexConsumer);
        }
    }

    @Deprecated
    private class BakedModelConsumerImpl
    implements RenderContext.BakedModelConsumer {
        private BakedModelConsumerImpl() {
        }

        public void accept(BakedModel model) {
            this.accept(model, null);
        }

        public void accept(BakedModel model, @Nullable BlockState state) {
            ItemRenderContext.this.bufferDefaultModel(model, state);
        }
    }

    @FunctionalInterface
    public static interface VanillaModelBufferer {
        public void accept(BakedModel var1, ItemStack var2, int var3, int var4, PoseStack var5, VertexConsumer var6);
    }
}

