/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.model.quad.blender;

import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.caffeinemc.mods.sodium.client.model.color.ColorProvider;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadView;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;

public abstract class BlendedColorProvider<T>
implements ColorProvider<T> {
    @Override
    public void getColors(LevelSlice slice, BlockPos pos, BlockPos.MutableBlockPos scratchPos, T state, ModelQuadView quad, int[] output) {
        for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
            output[vertexIndex] = this.getVertexColor(slice, pos, scratchPos, quad, state, vertexIndex);
        }
    }

    private int getVertexColor(LevelSlice slice, BlockPos pos, BlockPos.MutableBlockPos scratchPos, ModelQuadView quad, T state, int vertexIndex) {
        float posX = quad.getX(vertexIndex) - 0.5f;
        float posY = quad.getY(vertexIndex) - 0.5f;
        float posZ = quad.getZ(vertexIndex) - 0.5f;
        int posIntX = Mth.floor((float)posX);
        int posIntY = Mth.floor((float)posY);
        int posIntZ = Mth.floor((float)posZ);
        int blockIntX = pos.getX() + posIntX;
        int blockIntY = pos.getY() + posIntY;
        int blockIntZ = pos.getZ() + posIntZ;
        int c00 = this.getColor(slice, state, (BlockPos)scratchPos.set(blockIntX + 0, blockIntY, blockIntZ + 0));
        int c01 = this.getColor(slice, state, (BlockPos)scratchPos.set(blockIntX + 0, blockIntY, blockIntZ + 1));
        int c10 = this.getColor(slice, state, (BlockPos)scratchPos.set(blockIntX + 1, blockIntY, blockIntZ + 0));
        int c11 = this.getColor(slice, state, (BlockPos)scratchPos.set(blockIntX + 1, blockIntY, blockIntZ + 1));
        int z0 = c00 != c01 ? ColorMixer.mix(c00, c01, posZ - (float)posIntZ) : c00;
        int z1 = c10 != c11 ? ColorMixer.mix(c10, c11, posZ - (float)posIntZ) : c10;
        int x0 = z0 != z1 ? ColorMixer.mix(z0, z1, posX - (float)posIntX) : z0;
        return x0;
    }

    protected abstract int getColor(LevelSlice var1, T var2, BlockPos var3);
}

