/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.datagen;

import alexthw.not_enough_glyphs.init.ArsNouveauRegistry;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.GlyphScribePage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.PatchouliBuilder;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.TextPage;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;

public class PatchouliProvider
extends com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider {
    public PatchouliProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput cache) {
        for (AbstractSpellPart part : ArsNouveauRegistry.registeredSpells) {
            this.addGlyphPage(part);
        }
        for (PatchouliProvider.PatchouliPage page : this.pages) {
            this.saveStable(cache, (JsonElement)page.build(), page.path());
        }
    }

    public void addGlyphPage(AbstractSpellPart spellPart) {
        ResourceLocation category = switch (spellPart.defaultTier().value) {
            case 1 -> GLYPHS_1;
            case 2 -> GLYPHS_2;
            default -> GLYPHS_3;
        };
        PatchouliBuilder builder = new PatchouliBuilder(category, spellPart.getName()).withName(spellPart.getRegistryName().getNamespace() + ".glyph_name." + spellPart.getRegistryName().getPath()).withIcon(spellPart.getRegistryName().toString()).withSortNum(spellPart instanceof AbstractCastMethod ? 1 : (spellPart instanceof AbstractEffect ? 2 : 3)).withPage((IPatchouliPage)new TextPage(spellPart.getRegistryName().getNamespace() + ".glyph_desc." + spellPart.getRegistryName().getPath())).withPage((IPatchouliPage)new GlyphScribePage(spellPart));
        if (!spellPart.getRegistryName().getNamespace().equals("not_enough_glyphs")) {
            builder.withProperty("!flag", "mod:" + spellPart.getRegistryName().getNamespace());
        }
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(category, spellPart.getRegistryName().getPath())));
    }
}

