/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.spell;

import alexthw.not_enough_glyphs.common.glyphs.MethodTrail;
import alexthw.not_enough_glyphs.init.Registry;
import com.hollingsworth.arsnouveau.api.block.IPrismaticBlock;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class TrailingProjectile
extends EntityProjectileSpell {
    public static final EntityDataAccessor<Integer> DELAY = SynchedEntityData.defineId(TrailingProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> AOE = SynchedEntityData.defineId(TrailingProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public int maxProcs = 20;
    public int totalProcs;

    public TrailingProjectile(EntityType<? extends EntityProjectileSpell> entityType, Level world) {
        super(entityType, world);
    }

    public TrailingProjectile(Level world, SpellResolver resolver) {
        super(Registry.TRAILING_PROJECTILE.get(), world, resolver);
    }

    public int getExpirationTime() {
        return MethodTrail.INSTANCE.getProjectileLifespan() * 20;
    }

    public EntityType<?> getType() {
        return Registry.TRAILING_PROJECTILE.get();
    }

    public void tick() {
        if (this.age > 5 && this.totalProcs < this.maxProcs && this.age % Math.max(2, 12 - 2 * this.getDelay()) == 0) {
            this.castSpells();
        }
        super.tick();
    }

    public void traceAnyHit(@Nullable HitResult rayTraceResult, Vec3 thisPosition, Vec3 nextPosition) {
        EntityHitResult entityraytraceresult;
        if (rayTraceResult != null && rayTraceResult.getType() != HitResult.Type.MISS) {
            nextPosition = rayTraceResult.getLocation();
        }
        if ((entityraytraceresult = this.findHitEntity(thisPosition, nextPosition)) != null) {
            rayTraceResult = entityraytraceresult;
        }
        if (rayTraceResult != null && rayTraceResult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)rayTraceResult)) {
            Level level = this.level();
            if (!level.isClientSide && rayTraceResult instanceof BlockHitResult) {
                BlockHitResult blockRaytraceResult = (BlockHitResult)rayTraceResult;
                if (!this.isRemoved() && !this.hitList.contains(blockRaytraceResult.getBlockPos())) {
                    BlockState state = level.getBlockState(blockRaytraceResult.getBlockPos());
                    Block block = state.getBlock();
                    if (block instanceof IPrismaticBlock) {
                        IPrismaticBlock prismaticBlock = (IPrismaticBlock)block;
                        prismaticBlock.onHit((ServerLevel)level, blockRaytraceResult.getBlockPos(), (EntityProjectileSpell)this);
                        return;
                    }
                    if (state.is(BlockTags.PORTALS)) {
                        state.entityInside(level, blockRaytraceResult.getBlockPos(), (Entity)this);
                        return;
                    }
                    if (state.getBlock() instanceof TargetBlock) {
                        this.onHitBlock(blockRaytraceResult);
                    }
                    this.attemptRemoval();
                    this.hitList.add(blockRaytraceResult.getBlockPos());
                }
            }
            this.hasImpulse = true;
        }
        if (rayTraceResult != null && rayTraceResult.getType() == HitResult.Type.MISS && rayTraceResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
            if (this.canTraversePortals()) {
                ((PortalBlock)BlockRegistry.PORTAL_BLOCK.get()).onProjectileHit(this.level(), this.level().getBlockState(BlockPos.containing((Position)rayTraceResult.getLocation())), blockHitResult, (Projectile)this);
            }
        }
    }

    protected void attemptRemoval() {
        ++this.totalProcs;
        super.attemptRemoval();
    }

    public void castSpells() {
        float aoe = this.getAoe();
        int flatAoe = Math.round(aoe);
        if (!this.level().isClientSide) {
            if (this.isSensitive()) {
                int counter = 0;
                for (BlockPos p : BlockPos.betweenClosed((BlockPos)this.blockPosition().east(flatAoe).north(flatAoe), (BlockPos)this.blockPosition().west(flatAoe).south(flatAoe))) {
                    this.spellResolver.onResolveEffect(this.level(), (HitResult)new BlockHitResult(Vec3.atCenterOf((Vec3i)p), Direction.DOWN, p, true));
                    this.hitList.add(p.immutable());
                    ++counter;
                }
                if (counter > 0) {
                    this.totalProcs += Math.max(1, (int)((float)counter / (10.0f + this.getAoe())));
                }
            } else {
                int i = 0;
                for (Entity entity : this.level().getEntities(null, new AABB(this.blockPosition()).inflate((double)this.getAoe()))) {
                    if (entity.equals((Object)this) || entity.getType().is(EntityTags.LINGERING_BLACKLIST)) continue;
                    this.spellResolver.onResolveEffect(this.level(), (HitResult)new EntityHitResult(entity));
                    if (++i <= 5) continue;
                    break;
                }
                this.totalProcs += i;
            }
            if (this.totalProcs >= this.maxProcs) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        } else {
            this.level().addParticle((ParticleOptions)ParticleTypes.SONIC_BOOM, this.getX(), this.getY(), this.getZ(), this.getDeltaMovement().x(), this.getDeltaMovement().y(), this.getDeltaMovement().z());
        }
    }

    public int getDelay() {
        return (Integer)this.entityData.get(DELAY);
    }

    public void setDelay(int time) {
        this.entityData.set(DELAY, (Object)time);
    }

    public void setAoe(double aoe) {
        this.entityData.set(AOE, (Object)Float.valueOf((float)aoe));
    }

    public float getAoe() {
        return (float)(this.isSensitive() ? 0 : 2) + ((Float)this.entityData.get(AOE)).floatValue();
    }

    public boolean isSensitive() {
        return this.numSensitive > 0;
    }

    public int getParticleDelay() {
        return 0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DELAY, (Object)0);
        pBuilder.define(AOE, (Object)Float.valueOf(0.0f));
    }
}

