/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.spell;

import alexthw.not_enough_glyphs.init.Registry;
import com.hollingsworth.arsnouveau.api.block.IPrismaticBlock;
import com.hollingsworth.arsnouveau.api.event.SpellProjectileHitEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class MissileProjectile
extends EntityProjectileSpell {
    public SpellResolver spellResolver;
    public float aoe;
    public boolean activateOnEmpty;
    int maxAge = 200;
    public Set<BlockPos> hitList = new HashSet<BlockPos>();

    public MissileProjectile(EntityType<? extends MissileProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public MissileProjectile(Level world, SpellResolver resolver) {
        this(world, resolver, 200, true, resolver.spell.getBuffsAtIndex(0, resolver.spellContext.getUnwrappedCaster(), (AbstractAugment)AugmentAOE.INSTANCE));
    }

    public MissileProjectile(Level world, SpellResolver resolver, int maxAge, boolean activate, float aoe) {
        super(Registry.MISSILE_PROJECTILE.get(), world, resolver);
        this.spellResolver = resolver;
        this.aoe = aoe;
        this.maxAge = maxAge;
        this.activateOnEmpty = activate;
    }

    public void tick() {
        super.tick();
        if (this.age > this.maxAge) {
            this.ExplodeMissile();
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void onHit(HitResult result) {
        result = this.transformHitResult(result);
        if (!this.level().isClientSide) {
            SpellProjectileHitEvent event = new SpellProjectileHitEvent((EntityProjectileSpell)this, result);
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
            if (result instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)result;
                if (entityHitResult.getEntity().equals((Object)this.getOwner())) {
                    return;
                }
                if (this.spellResolver != null) {
                    this.activateSpellAtPos(entityHitResult.getEntity().position());
                    Networking.sendToNearbyClient((Level)this.level(), (BlockPos)BlockPos.containing((Position)result.getLocation()), (CustomPacketPayload)new PacketANEffect(PacketANEffect.EffectType.BURST, BlockPos.containing((Position)result.getLocation()), this.getParticleColor(), new int[0]));
                    this.attemptRemoval();
                }
            }
            if (result instanceof BlockHitResult) {
                BlockHitResult blockraytraceresult = (BlockHitResult)result;
                if (!this.isRemoved() && !this.hitList.contains(blockraytraceresult.getBlockPos())) {
                    BlockState state = this.level().getBlockState(blockraytraceresult.getBlockPos());
                    Block block = state.getBlock();
                    if (block instanceof IPrismaticBlock) {
                        IPrismaticBlock prismaticBlock = (IPrismaticBlock)block;
                        prismaticBlock.onHit((ServerLevel)this.level(), blockraytraceresult.getBlockPos(), (EntityProjectileSpell)this);
                        return;
                    }
                    if (state.is(BlockTags.PORTALS)) {
                        state.entityInside(this.level(), blockraytraceresult.getBlockPos(), (Entity)this);
                        return;
                    }
                    if (state.getBlock() instanceof TargetBlock) {
                        this.onHitBlock(blockraytraceresult);
                    }
                    if (this.spellResolver != null) {
                        this.hitList.add(blockraytraceresult.getBlockPos());
                        this.activateSpellAtPos(blockraytraceresult.getLocation());
                        Networking.sendToNearbyClient((Level)this.level(), (BlockPos)blockraytraceresult.getBlockPos(), (CustomPacketPayload)new PacketANEffect(PacketANEffect.EffectType.BURST, blockraytraceresult.getBlockPos().below(), this.getParticleColor(), new int[0]));
                    }
                    Networking.sendToNearbyClient((Level)this.level(), (BlockPos)((BlockHitResult)result).getBlockPos(), (CustomPacketPayload)new PacketANEffect(PacketANEffect.EffectType.BURST, BlockPos.containing((Position)result.getLocation()).below(), this.getParticleColor(), new int[0]));
                    this.attemptRemoval();
                }
            }
        }
    }

    public void playParticles() {
        float size = 5.0f;
        double deltaX = this.getX() - this.xOld;
        double deltaY = this.getY() - this.yOld;
        double deltaZ = this.getZ() - this.zOld;
        double dist = Math.ceil(Math.sqrt((deltaX *= (double)size) * deltaX + (deltaY *= (double)size) * deltaY + (deltaZ *= (double)size) * deltaZ) * 6.0);
        for (double j = 0.0; j < dist; j += 1.0) {
            double coeff = j / dist;
            this.level().addParticle(GlowParticleData.createData((ParticleColor)this.getParticleColor(), (float)(0.25f + size), (float)1.0f, (int)36), (double)((float)(this.xo + deltaX * coeff)), (double)((float)(this.yo + deltaY * coeff)) + 0.1, (double)((float)(this.zo + deltaZ * coeff)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)));
        }
    }

    protected void activateSpellAtPos(Vec3 pos) {
        if (!this.level().isClientSide() && this.spellResolver != null) {
            float sideOffset = 5.0f + 1.3f * this.aoe;
            float upOffset = 2.0f + this.aoe;
            Vec3 offset = new Vec3((double)sideOffset, (double)upOffset, (double)sideOffset);
            AABB axis = new AABB(pos.x + offset.x, pos.y + offset.y, pos.z + offset.z, pos.x - offset.x, pos.y - offset.y, pos.z - offset.z);
            List entities = this.level().getEntitiesOfClass(LivingEntity.class, axis, entity -> entity != this.spellResolver.spellContext.getUnwrappedCaster());
            if (!entities.isEmpty()) {
                for (LivingEntity entity2 : entities) {
                    this.spellResolver.onResolveEffect(this.level(), (HitResult)new EntityHitResult((Entity)entity2));
                }
            } else if (this.activateOnEmpty) {
                Vec3 vector3d2 = this.position();
                Vec3 dist = this.getOwner() == null ? new Vec3(0.0, 1.0, 0.0) : this.position().subtract(this.getOwner().position());
                this.spellResolver.onResolveEffect(this.level(), (HitResult)new BlockHitResult(vector3d2, Direction.getNearest((double)dist.x, (double)dist.y, (double)dist.z), BlockPos.containing((Position)vector3d2), true));
            }
        }
    }

    protected void ExplodeMissile() {
        this.activateSpellAtPos(this.position());
        Networking.sendToNearbyClient((Level)this.level(), (BlockPos)this.getOnPos(), (CustomPacketPayload)new PacketANEffect(PacketANEffect.EffectType.BURST, this.getOnPos(), this.getParticleColor(), new int[0]));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("maxAge")) {
            this.maxAge = tag.getInt("maxAge");
        }
        if (tag.contains("aoe")) {
            this.aoe = tag.getFloat("aoe");
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("maxAge", this.maxAge);
        tag.putFloat("aoe", this.aoe);
    }
}

