/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs.propagators;

import alexthw.not_enough_glyphs.api.IPropagator;
import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import alexthw.not_enough_glyphs.common.glyphs.EffectChaining;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBurst;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLinger;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWall;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class PropagatePlane
extends AbstractEffect
implements IPropagator {
    public static final PropagatePlane INSTANCE = new PropagatePlane();

    private PropagatePlane() {
        super(CompatRL.neg("propagate_plane"), "Propagate Plane");
    }

    protected void addDefaultInvalidCombos(Set<ResourceLocation> defaults) {
        defaults.addAll(Stream.of(new AbstractEffect[]{EffectWall.INSTANCE, EffectLinger.INSTANCE, EffectBurst.INSTANCE, EffectChaining.INSTANCE}).map(AbstractSpellPart::getRegistryName).toList());
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver((HitResult)rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockHitResult blockHitResult = new BlockHitResult(rayTraceResult.getLocation(), Direction.DOWN, rayTraceResult.getEntity().getOnPos(), rayTraceResult.getEntity() == shooter);
        this.copyResolver((HitResult)blockHitResult, world, shooter, spellStats, spellContext, resolver);
    }

    @Override
    public void propagate(Level world, HitResult hitResult, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        double width = 1.0 + stats.getAoeMultiplier();
        int height = stats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE);
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        if (this.isRealPlayer((Entity)shooter)) {
            blockHitResult = new BlockHitResult(blockHitResult.getLocation(), blockHitResult.getDirection().getOpposite(), blockHitResult.getBlockPos(), blockHitResult.isInside());
        }
        BlockPos center = blockHitResult.getBlockPos();
        if (stats.isSensitive()) {
            this.circle(world, resolver, shooter, blockHitResult, center, width, height, stats.hasBuff((AbstractAugment)AugmentDampen.INSTANCE), stats.getBuffCount((AbstractAugment)AugmentRandomize.INSTANCE));
        } else {
            PropagatePlane.cube(world, resolver, shooter, blockHitResult, center, width, height, stats.hasBuff((AbstractAugment)AugmentDampen.INSTANCE), stats.getBuffCount((AbstractAugment)AugmentRandomize.INSTANCE));
        }
    }

    private void circle(Level world, SpellResolver resolver, LivingEntity shooter, BlockHitResult blockHitResult, BlockPos center, double width, int height, boolean isHollow, int random) {
        int anchor;
        int radius = (int)width;
        anchor = switch (blockHitResult.getDirection()) {
            default -> throw new MatchException(null, null);
            case Direction.EAST, Direction.WEST -> anchor = center.getX();
            case Direction.NORTH, Direction.SOUTH -> anchor = center.getZ();
            case Direction.UP, Direction.DOWN -> anchor = center.getY();
        };
        for (BlockPos pos : SpellUtil.calcAOEBlocks((LivingEntity)shooter, (BlockPos)center, (BlockHitResult)blockHitResult, (double)(width * 2.0), (int)height)) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            if (random > 0 && shooter.getRandom().nextFloat() <= (float)random / 4.0f) continue;
            double distance = BlockUtil.distanceFromCenter((BlockPos)center, (BlockPos)(switch (blockHitResult.getDirection()) {
                default -> throw new MatchException(null, null);
                case Direction.EAST, Direction.WEST -> new BlockPos(center.getX(), y, z);
                case Direction.UP, Direction.DOWN -> new BlockPos(x, center.getY(), z);
                case Direction.NORTH, Direction.SOUTH -> new BlockPos(x, y, center.getZ());
            }));
            if (isHollow) {
                if (!(distance <= (double)radius + 0.5) || !(distance >= (double)radius - 0.5)) continue;
                resolver.onResolveEffect(world, (HitResult)new BlockHitResult(new Vec3((double)x, (double)y, (double)z), !blockHitResult.isInside() ? blockHitResult.getDirection().getOpposite() : blockHitResult.getDirection(), BlockPos.containing((double)x, (double)y, (double)z), blockHitResult.isInside()));
                continue;
            }
            if (!(distance <= (double)radius)) continue;
            resolver.onResolveEffect(world, (HitResult)new BlockHitResult(new Vec3((double)x, (double)y, (double)z), !blockHitResult.isInside() ? blockHitResult.getDirection().getOpposite() : blockHitResult.getDirection(), BlockPos.containing((double)x, (double)y, (double)z), blockHitResult.isInside()));
        }
    }

    private static void cube(Level world, SpellResolver resolver, LivingEntity shooter, BlockHitResult blockHitResult, BlockPos center, double width, int height, boolean isHollow, int random) {
        Direction.Axis axis;
        int maxY;
        int minY;
        int maxZ;
        int minZ;
        int maxX;
        int minX;
        if (isHollow) {
            width += width % 2.0;
        }
        switch (blockHitResult.getDirection()) {
            case EAST: 
            case WEST: {
                minX = center.getX();
                maxX = center.getX() + height;
                minZ = (int)((double)center.getZ() - width / 2.0);
                maxZ = (int)((double)center.getZ() + width / 2.0);
                minY = (int)((double)center.getY() - width / 2.0);
                maxY = (int)((double)center.getY() + width / 2.0);
                axis = Direction.Axis.X;
                break;
            }
            case NORTH: 
            case SOUTH: {
                minX = (int)((double)center.getX() - width / 2.0);
                maxX = (int)((double)center.getX() + width / 2.0);
                minZ = center.getZ();
                maxZ = center.getZ() + height;
                minY = (int)((double)center.getY() - width / 2.0);
                maxY = (int)((double)center.getY() + width / 2.0);
                axis = Direction.Axis.Z;
                break;
            }
            case UP: 
            case DOWN: {
                minX = (int)((double)center.getX() - width / 2.0);
                maxX = (int)((double)center.getX() + width / 2.0);
                minZ = (int)((double)center.getZ() - width / 2.0);
                maxZ = (int)((double)center.getZ() + width / 2.0);
                minY = center.getY();
                maxY = center.getY() + height;
                axis = Direction.Axis.Y;
                break;
            }
            default: {
                return;
            }
        }
        block10: for (BlockPos p : SpellUtil.calcAOEBlocks((LivingEntity)shooter, (BlockPos)center, (BlockHitResult)blockHitResult, (double)width, (int)height)) {
            if (random > 0 && shooter.getRandom().nextFloat() <= (float)random / 4.0f) continue;
            if (isHollow) {
                switch (axis) {
                    case X: {
                        if (p.getZ() == minZ || p.getZ() == maxZ || p.getY() == minY || p.getY() == maxY) break;
                        continue block10;
                    }
                    case Y: {
                        if (p.getX() == minX || p.getX() == maxX || p.getZ() == minZ || p.getZ() == maxZ) break;
                        continue block10;
                    }
                    case Z: {
                        if (p.getX() == minX || p.getX() == maxX || p.getY() == minY || p.getY() == maxY) break;
                        continue block10;
                    }
                }
            }
            resolver.onResolveEffect(world, (HitResult)new BlockHitResult(p.getCenter(), !blockHitResult.isInside() ? blockHitResult.getDirection().getOpposite() : blockHitResult.getDirection(), p, blockHitResult.isInside()));
        }
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.PER_SPELL_LIMIT = builder.comment("The maximum number of times this glyph may appear in a single spell").defineInRange("per_spell_limit", 1, 1, 1);
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public Integer getTypeIndex() {
        return 8;
    }

    protected int getDefaultManaCost() {
        return 200;
    }

    protected void addAugmentCostOverrides(Map<ResourceLocation, Integer> defaults) {
        super.addAugmentCostOverrides(defaults);
        defaults.put(AugmentSensitive.INSTANCE.getRegistryName(), 100);
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentRandomize.INSTANCE, AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentDampen.INSTANCE, AugmentSensitive.INSTANCE});
    }
}

