/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs;

import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import alexthw.not_enough_glyphs.common.spell.MissileProjectile;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class MethodMissile
extends AbstractCastMethod {
    public static final MethodMissile INSTANCE = new MethodMissile("missile", "Missile");
    public ModConfigSpec.IntValue PROJECTILE_TTL;

    public MethodMissile(String path, String description) {
        super(CompatRL.omega(path), description);
    }

    public static float getProjectileSpeed(SpellStats stats) {
        return Math.max(0.1f, 0.75f + stats.getAccMultiplier() / 2.0f);
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.PROJECTILE_TTL = builder.comment("Max lifespan of the projectile, in seconds.").defineInRange("max_lifespan", 60, 0, Integer.MAX_VALUE);
    }

    public void summonProjectiles(Level world, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        boolean activate = true;
        int duration = (int)Math.max(5.0, 30.0 + 7.0 * stats.getDurationMultiplier());
        ArrayList<MissileProjectile> projectiles = new ArrayList<MissileProjectile>();
        int numSplits = stats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE);
        float sizeRatio = shooter.getEyeHeight() / 1.62f;
        boolean gravity = stats.hasBuff((AbstractAugment)AugmentDampen.INSTANCE);
        for (int i = 1; i < 1 + numSplits + 1; ++i) {
            MissileProjectile projectileSpell = new MissileProjectile(world, resolver, duration, true, (float)stats.getAoeMultiplier());
            projectiles.add(projectileSpell);
        }
        float velocity = MethodMissile.getProjectileSpeed(stats);
        int opposite = -1;
        int counter = 0;
        for (MissileProjectile proj : projectiles) {
            proj.setPos(proj.position().add(0.0, 0.25 * (double)sizeRatio, 0.0));
            proj.shoot((Entity)shooter, shooter.getXRot(), shooter.getYRot() + (float)(Math.round((double)counter / 2.0) * 5L * (long)opposite), 0.0f, velocity, 0.5f);
            opposite *= -1;
            ++counter;
            proj.setGravity(gravity);
            world.addFreshEntity((Entity)proj);
        }
    }

    public int getDefaultManaCost() {
        return 20;
    }

    public CastResolveType onCast(ItemStack stack, LivingEntity shooter, Level world, SpellStats stats, SpellContext context, SpellResolver resolver) {
        this.summonProjectiles(world, shooter, stats, resolver);
        return CastResolveType.SUCCESS;
    }

    public CastResolveType onCastOnBlock(UseOnContext context, SpellStats stats, SpellContext spellContext, SpellResolver resolver) {
        Level world = context.getLevel();
        Player shooter = context.getPlayer();
        this.summonProjectiles(world, (LivingEntity)shooter, stats, resolver);
        return CastResolveType.SUCCESS;
    }

    public CastResolveType onCastOnBlock(BlockHitResult blockRayTraceResult, LivingEntity caster, SpellStats stats, SpellContext spellContext, SpellResolver resolver) {
        caster.lookAt(EntityAnchorArgument.Anchor.EYES, blockRayTraceResult.getLocation().add(0.0, 0.0, 0.0));
        this.summonProjectiles(caster.getCommandSenderWorld(), caster, stats, resolver);
        return CastResolveType.SUCCESS;
    }

    public CastResolveType onCastOnEntity(ItemStack stack, LivingEntity caster, Entity target, InteractionHand hand, SpellStats stats, SpellContext spellContext, SpellResolver resolver) {
        this.summonProjectiles(caster.getCommandSenderWorld(), caster, stats, resolver);
        return CastResolveType.SUCCESS;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentPierce.INSTANCE, AugmentSplit.INSTANCE, AugmentAccelerate.INSTANCE, AugmentSensitive.INSTANCE, AugmentDurationDown.INSTANCE, AugmentExtendTime.INSTANCE, AugmentAOE.INSTANCE, AugmentDampen.INSTANCE});
    }

    public String getBookDescription() {
        return "Summons a projectile that applies spell effects in a small area when this projectile hits a target or expires. Sensitive will allow Projectiles to break plants or other materials that do not block motion.";
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.ELEMENTAL_AIR, SpellSchools.ELEMENTAL_FIRE});
    }

    public Glyph getGlyph() {
        if (this.glyphItem == null) {
            this.glyphItem = new Glyph(this, (AbstractSpellPart)this){

                @NotNull
                public String getCreatorModId(@NotNull ItemStack itemStack) {
                    return "not_enough_glyphs";
                }
            };
        }
        return this.glyphItem;
    }
}

