/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs;

import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import alexthw.not_enough_glyphs.common.network.PacketRayEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBurst;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLinger;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWall;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectChaining
extends AbstractEffect {
    public static final EffectChaining INSTANCE = new EffectChaining("chaining", "Chaining");
    public ModConfigSpec.IntValue BASE_MAX_BLOCKS;
    public ModConfigSpec.IntValue BONUS_BLOCKS;
    public ModConfigSpec.DoubleValue BASE_BLOCK_DISTANCE;
    public ModConfigSpec.DoubleValue BONUS_BLOCK_DISTANCE;
    public ModConfigSpec.IntValue BASE_MAX_ENTITIES;
    public ModConfigSpec.IntValue BONUS_ENTITIES;
    public ModConfigSpec.DoubleValue BASE_ENTITY_DISTANCE;
    public ModConfigSpec.DoubleValue BONUS_ENTITY_DISTANCE;

    public EffectChaining(String tag, String description) {
        super(CompatRL.tmg(tag), description);
    }

    protected void addDefaultInvalidCombos(Set<ResourceLocation> defaults) {
        defaults.addAll(Stream.of(EffectLinger.INSTANCE, EffectWall.INSTANCE, EffectBurst.INSTANCE).map(AbstractSpellPart::getRegistryName).toList());
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.PER_SPELL_LIMIT = builder.comment("The maximum number of times this glyph may appear in a single spell").defineInRange("per_spell_limit", 1, 1, Integer.MAX_VALUE);
        this.BASE_MAX_BLOCKS = builder.comment("Base maximum number of blocks struck when targeting blocks").defineInRange("base_max_blocks", 16, 1, Integer.MAX_VALUE);
        this.BONUS_BLOCKS = builder.comment("Bonus to maximum blocks per augment").defineInRange("bonus_blocks", 16, 1, Integer.MAX_VALUE);
        this.BASE_BLOCK_DISTANCE = builder.comment("Base search distance around each target block").defineInRange("base_block_search_distance_euclidean", 1.75, 1.0, 2.147483647E9);
        this.BONUS_BLOCK_DISTANCE = builder.comment("Bonus search distance around each target block per augment").defineInRange("bonus_block_distance_euclidean", 1.0, 1.0, 2.147483647E9);
        this.BASE_MAX_ENTITIES = builder.comment("Base maximum number of entities struck when targeting entities").defineInRange("base_max_entities", 8, 1, Integer.MAX_VALUE);
        this.BONUS_ENTITIES = builder.comment("Bonus to maximum entities per augment").defineInRange("bonus_entities", 16, 1, Integer.MAX_VALUE);
        this.BASE_ENTITY_DISTANCE = builder.comment("Base search distance around each target entity").defineInRange("base_entity_distance", 8.0, 0.0, Double.MAX_VALUE);
        this.BONUS_ENTITY_DISTANCE = builder.comment("Bonus search distance around each target entity per augment").defineInRange("bonus_entity_distance", 4.0, 0.0, Double.MAX_VALUE);
    }

    private static Vec3 getBlockCenter(BlockPos blockPos) {
        return new Vec3((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        int maxBlocks = (int)((double)((Integer)this.BASE_MAX_BLOCKS.get()).intValue() + (double)((Integer)this.BONUS_BLOCKS.get()).intValue() * spellStats.getAoeMultiplier());
        double searchDistance = (Double)this.BASE_BLOCK_DISTANCE.get() + (Double)this.BONUS_BLOCK_DISTANCE.get() * (double)spellStats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE);
        int searchBlockDistance = (int)Math.ceil(searchDistance);
        double searchDistanceSqr = searchDistance * searchDistance;
        BlockState struck = world.getBlockState(rayTraceResult.getBlockPos());
        Predicate<BlockPos> chainFilter = switch (spellStats.getBuffCount((AbstractAugment)AugmentSensitive.INSTANCE)) {
            case 1 -> bp -> world.getBlockState(bp).is(struck.getBlock()) && Direction.allShuffled((RandomSource)shooter.getRandom()).stream().anyMatch(d -> world.getBlockState(bp.relative(d)).canBeReplaced());
            case 2 -> bp -> world.getBlockState(bp).is(struck.getBlock()) && world.getBlockState(bp.relative(rayTraceResult.getDirection())).canBeReplaced();
            default -> bp -> world.getBlockState(bp).is(struck.getBlock());
        };
        Iterable<Edge<BlockPos>> chain = EffectChaining.SearchTargets(Collections.singleton(rayTraceResult.getBlockPos()), maxBlocks, EffectChaining::getBlockCenter, bp -> EffectChaining.getBlockCenter(bp).subtract(EffectChaining.getBlockCenter(rayTraceResult.getBlockPos())).length() * 0.01, (bp, isMatch) -> BlockPos.betweenClosedStream((BlockPos)bp.offset(searchBlockDistance, searchBlockDistance, searchBlockDistance), (BlockPos)bp.offset(-searchBlockDistance, -searchBlockDistance, -searchBlockDistance)).filter(nbp -> EffectChaining.getBlockCenter(bp).distanceToSqr(EffectChaining.getBlockCenter(nbp)) <= searchDistanceSqr && isMatch.test(nbp)).map(BlockPos::immutable).collect(Collectors.toCollection(ArrayList::new)), chainFilter);
        spellContext.setCanceled(true);
        Spell continuation = spellContext.getRemainingSpell();
        for (Edge<BlockPos> edge : chain) {
            Vec3 toCenter = EffectChaining.getBlockCenter((BlockPos)edge.to);
            BlockHitResult chainedRayTraceResult = new BlockHitResult(toCenter, rayTraceResult.getDirection(), (BlockPos)edge.to, true);
            Networking.sendToNearbyClient((Level)world, (BlockPos)((BlockPos)edge.to), (CustomPacketPayload)new PacketRayEffect(EffectChaining.getBlockCenter((BlockPos)edge.from), toCenter, spellContext.getColors()));
            SpellContext newContext = spellContext.clone().withSpell(continuation);
            resolver.getNewResolver(newContext).onResolveEffect(world, (HitResult)chainedRayTraceResult);
        }
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        int maxEntities = (int)((double)((Integer)this.BASE_MAX_ENTITIES.get()).intValue() + (double)((Integer)this.BONUS_ENTITIES.get()).intValue() * spellStats.getAoeMultiplier());
        double distance = (Double)this.BASE_ENTITY_DISTANCE.get() + (Double)this.BONUS_ENTITY_DISTANCE.get() * (double)spellStats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE);
        double distanceSqr = distance * distance;
        Entity struck = rayTraceResult.getEntity();
        spellContext.setCanceled(true);
        Predicate<Entity> entityMatch = spellStats.isSensitive() ? e -> e != shooter : e -> e != shooter && e.getType() == struck.getType();
        Iterable<Edge<Entity>> chain = EffectChaining.SearchTargets(Collections.singleton(struck), maxEntities, Entity::position, e -> (double)e.distanceTo(struck) * 0.01, (e, isMatch) -> world.getEntitiesOfClass(Entity.class, new AABB(e.position().x + distance, e.position().y + distance, e.position().z + distance, e.position().x - distance, e.position().y - distance, e.position().z - distance), t -> t.position().distanceToSqr(e.position()) <= distanceSqr && isMatch.test(t)), entityMatch);
        Spell continuation = spellContext.getRemainingSpell();
        for (Edge<Entity> edge : chain) {
            Vec3 midpoint = ((Entity)edge.from).position().add(((Entity)edge.to).position()).scale(0.5);
            double radius = 64.0 + ((Entity)edge.from).position().distanceTo(midpoint);
            if (world instanceof ServerLevel) {
                Networking.sendToNearbyClient((Level)world, (Entity)((Entity)edge.to), (CustomPacketPayload)new PacketRayEffect(((Entity)edge.from).position(), ((Entity)edge.to).position(), spellContext.getColors()));
            }
            SpellContext newContext = spellContext.clone().withSpell(continuation);
            resolver.getNewResolver(newContext).onResolveEffect(world, (HitResult)new EntityHitResult((Entity)edge.to));
        }
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    public int getDefaultManaCost() {
        return 300;
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentSensitive.INSTANCE.getRegistryName(), 2);
        defaults.put(AugmentExtract.INSTANCE.getRegistryName(), 1);
        defaults.put(AugmentDampen.INSTANCE.getRegistryName(), 1);
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.setOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentSensitive.INSTANCE});
    }

    public static Iterable<BlockPos> SearchBlockStates(Level world, Collection<BlockPos> start, int maxBlocks, int searchDistance, Predicate<BlockState> isMatch) {
        LinkedList<BlockPos> searchQueue = new LinkedList<BlockPos>(start);
        HashSet<BlockPos> searched = new HashSet<BlockPos>(start);
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        while (!searchQueue.isEmpty() && found.size() < maxBlocks) {
            BlockPos current = searchQueue.removeFirst();
            BlockState state = world.getBlockState(current);
            if (!isMatch.test(state)) continue;
            found.add(current);
            BlockPos.betweenClosedStream((BlockPos)current.offset(searchDistance, searchDistance, searchDistance), (BlockPos)current.offset(-searchDistance, -searchDistance, -searchDistance)).forEach(neighborMutable -> {
                if (searched.contains(neighborMutable)) {
                    return;
                }
                BlockPos neighbor = neighborMutable.immutable();
                searched.add(neighbor);
                searchQueue.add(neighbor);
            });
        }
        return found;
    }

    public static Iterable<Edge<Entity>> SearchEntities(Level world, Collection<Entity> start, int maxEntities, double searchDistance, Predicate<Entity> isMatch) {
        HashMap<Entity, Edge<Entity>> bestEdgeForTo = new HashMap<Entity, Edge<Entity>>();
        PriorityQueue<Edge> searchQueue = new PriorityQueue<Edge>(Comparator.comparingDouble(item -> item.distanceSqr));
        HashSet<Entity> selected = new HashSet<Entity>();
        ArrayList<Edge<Entity>> selectedEdges = new ArrayList<Edge<Entity>>();
        double searchDistanceSqr = searchDistance * searchDistance;
        start.stream().filter(isMatch).map(e -> new Edge<Entity>(0.0, (Entity)e, (Entity)e)).forEach(searchQueue::add);
        while (!searchQueue.isEmpty() && selected.size() < maxEntities) {
            Edge currentEdge = searchQueue.poll();
            Entity current = (Entity)currentEdge.to;
            selected.add(current);
            selectedEdges.add(currentEdge);
            Vec3 position = current.position();
            List neighbors = world.getEntitiesOfClass(Entity.class, new AABB(position.x + searchDistance, position.y + searchDistance, position.z + searchDistance, position.x - searchDistance, position.y - searchDistance, position.z - searchDistance), e -> e.position().distanceToSqr(current.position()) <= searchDistanceSqr && isMatch.test((Entity)e) && !selected.contains(e));
            for (Entity neighbor : neighbors) {
                double distanceSqr = neighbor.position().distanceToSqr(current.position());
                Edge bestKnown = (Edge)bestEdgeForTo.get(neighbor);
                if (bestKnown != null && !(bestKnown.distanceSqr > distanceSqr)) continue;
                Edge<Entity> toAdd = new Edge<Entity>(distanceSqr, current, neighbor);
                if (bestKnown != null) {
                    searchQueue.remove(bestKnown);
                }
                searchQueue.add(toAdd);
                bestEdgeForTo.put(neighbor, toAdd);
            }
        }
        return selectedEdges;
    }

    public static <T> Iterable<Edge<T>> SearchTargets(Collection<T> start, int maxTargets, Function<T, Vec3> getPosition, Function<T, Double> distanceAdjustment, BiFunction<T, Predicate<T>, Collection<T>> expandSearchNode, Predicate<T> isMatch) {
        HashMap bestEdgeForTo = new HashMap();
        PriorityQueue<Edge> searchQueue = new PriorityQueue<Edge>(Comparator.comparingDouble(item -> item.distanceSqr));
        HashSet selected = new HashSet();
        ArrayList<Edge<T>> selectedEdges = new ArrayList<Edge<T>>();
        start.stream().filter(isMatch).map(e -> new Edge<Object>(0.0, e, e)).forEach(searchQueue::add);
        while (!searchQueue.isEmpty() && selected.size() < maxTargets) {
            Edge currentEdge = searchQueue.poll();
            Object current = currentEdge.to;
            selected.add(current);
            selectedEdges.add(currentEdge);
            Collection<T> neighbors = expandSearchNode.apply(current, e -> !selected.contains(e) && isMatch.test(e));
            Vec3 position = getPosition.apply(current);
            for (T neighbor : neighbors) {
                double distanceSqr = getPosition.apply(neighbor).distanceToSqr(position) + distanceAdjustment.apply(neighbor);
                Edge bestKnown = (Edge)bestEdgeForTo.get(neighbor);
                if (bestKnown != null && !(bestKnown.distanceSqr > distanceSqr)) continue;
                Edge toAdd = new Edge(distanceSqr, current, neighbor);
                if (bestKnown != null) {
                    searchQueue.remove(bestKnown);
                }
                searchQueue.add(toAdd);
                bestEdgeForTo.put(neighbor, toAdd);
            }
        }
        return selectedEdges;
    }

    public Glyph getGlyph() {
        if (this.glyphItem == null) {
            this.glyphItem = new Glyph(this, (AbstractSpellPart)this){

                @NotNull
                public String getCreatorModId(@NotNull ItemStack itemStack) {
                    return "not_enough_glyphs";
                }
            };
        }
        return this.glyphItem;
    }

    public static class Edge<T> {
        public double distanceSqr;
        public T from;
        public T to;

        public Edge(double distanceSqr, T from, T to) {
            this.distanceSqr = distanceSqr;
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            return Double.compare(edge.distanceSqr, this.distanceSqr) == 0 && Objects.equals(this.from, edge.from) && Objects.equals(this.to, edge.to);
        }

        public int hashCode() {
            return Objects.hash(this.distanceSqr, this.from, this.to);
        }
    }
}

