/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.item;

import dev.ftb.mods.ftblibrary.config.ImageResourceConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.registry.ModDataComponents;
import dev.ftb.mods.ftbquests.registry.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class CustomIconItem
extends Item {
    private static final ResourceLocation FALLBACK_ICON = ResourceLocation.withDefaultNamespace((String)"textures/misc/unknown_pack.png");

    public CustomIconItem() {
        super(ModItems.defaultProps().stacksTo(1).component((DataComponentType)ModDataComponents.CUSTOM_ICON.get(), (Object)FALLBACK_ICON));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        if (level.isClientSide()) {
            FTBQuestsClient.openCustomIconGui(player, interactionHand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(interactionHand));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"item.ftbquests.custom_icon.tooltip").withStyle(ChatFormatting.GRAY));
        String icon = FTBQuests.getComponent(stack, ModDataComponents.CUSTOM_ICON).map(ResourceLocation::toString).orElse("-");
        tooltip.add((Component)Component.literal((String)icon).withStyle(ChatFormatting.DARK_GRAY));
    }

    public static Icon getIcon(ItemStack stack) {
        if (stack.getItem() instanceof CustomIconItem) {
            ResourceLocation icon = FTBQuests.getComponent(stack, ModDataComponents.CUSTOM_ICON).orElse(FALLBACK_ICON);
            return Icon.getIcon((ResourceLocation)icon);
        }
        return ItemIcon.getItemIcon((ItemStack)stack);
    }

    public static void setIcon(ItemStack stack, @Nullable ResourceLocation texture) {
        if (texture == null || texture.equals((Object)ImageResourceConfig.NONE)) {
            stack.remove((DataComponentType)ModDataComponents.CUSTOM_ICON.get());
        } else {
            stack.set((DataComponentType)ModDataComponents.CUSTOM_ICON.get(), (Object)texture);
        }
    }
}

