/*
 * Decompiled with CFR 0.152.
 */
package mars.laserbridges.com;

import mars.laserbridges.com.LaserBlock;
import mars.laserbridges.com.LaserSourceBlock;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="laserbridges")
public class LaserBridges {
    public static final String MODID = "laserbridges";
    public static int LIGHT = 10;
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"laserbridges");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"laserbridges");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"laserbridges");
    public static final DeferredBlock<Block> LASER_SOURCE_BLOCK = BLOCKS.register("laser_source_block", () -> new LaserSourceBlock(BlockBehaviour.Properties.of().strength(0.8f).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false ? LIGHT : 0)));
    public static final DeferredItem<BlockItem> LASER_SOURCE_BLOCK_ITEM = ITEMS.registerSimpleBlockItem("laser_source_block", LASER_SOURCE_BLOCK);
    public static final DeferredBlock<Block> LASER_BLOCK = BLOCKS.register("laser_block_powered", () -> new LaserBlock(BlockBehaviour.Properties.of().strength(-1.0f, 3600000.0f).noOcclusion().lightLevel(p_220871_ -> LIGHT)));
    public static final DeferredHolder<SoundEvent, SoundEvent> ON = LaserBridges.registerSoundEvent("on");
    public static final DeferredHolder<SoundEvent, SoundEvent> OFF = LaserBridges.registerSoundEvent("off");

    public static DeferredHolder<SoundEvent, SoundEvent> registerSoundEvent(String name) {
        return SOUND_EVENTS.register(name, () -> SoundEvent.createFixedRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name), (float)75.0f));
    }

    public LaserBridges(IEventBus modEventBus) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::clientSetup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)LASER_BLOCK.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)LASER_SOURCE_BLOCK.get()), (RenderType)RenderType.translucent());
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            event.accept(LASER_SOURCE_BLOCK_ITEM);
        }
    }
}

