/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.config.screen.base;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollableWidgetList
extends ContainerObjectSelectionList<Entry> {
    public ScrollableWidgetList(Minecraft minecraft, int width, int height, int y, int entryHeight) {
        super(minecraft, width, height, y, entryHeight);
    }

    public void removeEntries() {
        this.clearEntries();
    }

    @Nullable
    public Entry remove(int index) {
        return (Entry)super.remove(index);
    }

    public int addEntry(@NotNull Entry entry) {
        return super.addEntry((AbstractSelectionList.Entry)entry);
    }

    protected int getRowTop(int index) {
        return super.getRowTop(index);
    }

    protected int getScrollbarPosition() {
        return this.width - 7;
    }

    public int getRowWidth() {
        return this.width - 14;
    }

    @MethodsReturnNonnullByDefault
    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        final List<AbstractWidget> children;

        public Entry(List<AbstractWidget> widgets) {
            this.children = ImmutableList.copyOf(widgets);
        }

        public Entry(AbstractWidget ... widgets) {
            this.children = ImmutableList.copyOf(Arrays.stream(widgets).toList());
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            this.children.forEach(widget -> {
                widget.setY(top);
                widget.render(guiGraphics, mouseX, mouseY, partialTick);
            });
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }
    }
}

